/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security;

import io.undertow.security.api.NotificationReceiver;
import io.undertow.security.api.SecurityNotification;
import io.undertow.security.idm.Account;
import java.security.Principal;
import javax.security.auth.Subject;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.SecurityContext;
import org.wildfly.extension.undertow.security.AccountImpl;
import org.wildfly.extension.undertow.security.SecurityActions;
import org.wildfly.extension.undertow.security.UndertowSecurityAttachments;

public class LogoutNotificationReceiver
implements NotificationReceiver {
    private final AuthenticationManager manager;
    private final String securityDomain;

    public LogoutNotificationReceiver(AuthenticationManager manager, String securityDomain) {
        this.manager = manager;
        this.securityDomain = securityDomain;
    }

    public void handleNotification(SecurityNotification notification) {
        if (notification.getEventType() == SecurityNotification.EventType.LOGGED_OUT) {
            Principal principal;
            Account account = notification.getAccount();
            Principal principal2 = principal = account instanceof AccountImpl ? ((AccountImpl)account).getOriginalPrincipal() : account.getPrincipal();
            if (principal != null) {
                Subject subject = SecurityActions.getSubject();
                this.manager.logout(principal, subject);
            }
            SecurityActions.clearSecurityContext();
            SecurityActions.setSecurityRoles(null);
            SecurityContext securityContext = SecurityActions.createSecurityContext(this.securityDomain);
            notification.getExchange().putAttachment(UndertowSecurityAttachments.SECURITY_CONTEXT_ATTACHMENT, (Object)securityContext);
            SecurityActions.setSecurityContextOnAssociation(securityContext);
        }
    }
}

