/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.opentracing.smallrye;

import io.opentracing.Tracer;
import io.opentracing.noop.NoopTracerFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jboss.dmr.ModelNode;
import org.wildfly.microprofile.opentracing.smallrye.TracerConfiguration;

public class WildFlyTracerFactory {
    private static final Map<String, Configuration> CONFIGURATIONS = Collections.synchronizedMap(new HashMap());
    public static final String TRACER_CAPABILITY_NAME = "org.wildfly.microprofile.opentracing.tracer";
    public static final String ENV_TRACER = "org.wildfly.microprofile.opentracing.env-tracer";
    private static final Configuration DEFAULT_CONFIGURATION = new Configuration();

    public static Consumer<TracerConfiguration> registerTracer(String service) {
        assert (service != null);
        return CONFIGURATIONS.computeIfAbsent(service, name -> new Configuration());
    }

    public static Consumer<TracerConfiguration> registerDefaultTracer() {
        return DEFAULT_CONFIGURATION;
    }

    public static String getDefaultTracerName() {
        TracerConfiguration configuration = DEFAULT_CONFIGURATION.get();
        if (configuration != null) {
            return configuration.getName();
        }
        return null;
    }

    public static Tracer getTracer(String config, String serviceName) {
        if (serviceName != null && !serviceName.isEmpty()) {
            if (config != null && !config.isEmpty()) {
                TracerConfiguration configuration = CONFIGURATIONS.get(config).get();
                if (configuration != null) {
                    return configuration.createTracer(serviceName);
                }
            } else {
                TracerConfiguration configuration = CONFIGURATIONS.get(ENV_TRACER).get();
                if (configuration != null) {
                    return configuration.createTracer(serviceName);
                }
            }
        }
        return NoopTracerFactory.create();
    }

    public static ModelNode getModel(String config, String serviceName) {
        if (serviceName != null && !serviceName.isEmpty()) {
            if (config != null) {
                TracerConfiguration configuration = CONFIGURATIONS.get(config).get();
                if (configuration != null) {
                    return configuration.getModel();
                }
            } else {
                TracerConfiguration configuration = CONFIGURATIONS.get(ENV_TRACER).get();
                if (configuration != null) {
                    return configuration.getModel();
                }
            }
        }
        return new ModelNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<String> getModules() {
        Map<String, Configuration> map = CONFIGURATIONS;
        synchronized (map) {
            return CONFIGURATIONS.values().stream().map(Configuration::get).filter(config -> config != null).map(TracerConfiguration::getModuleName).collect(Collectors.toSet());
        }
    }

    private static final class Configuration
    implements Consumer<TracerConfiguration> {
        private TracerConfiguration t;

        private Configuration() {
        }

        @Override
        public void accept(TracerConfiguration t) {
            this.t = t;
        }

        public TracerConfiguration get() {
            return this.t;
        }
    }
}

