/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.cache;

import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.wildfly.clustering.ee.Manager;

public class ConcurrentManager<K, V>
implements Manager<K, V> {
    private final Map<K, Map.Entry<Integer, V>> objects = new ConcurrentHashMap<K, Map.Entry<Integer, V>>();
    private final BiFunction<K, Map.Entry<Integer, V>, Map.Entry<Integer, V>> addFunction = new BiFunction<K, Map.Entry<Integer, V>, Map.Entry<Integer, V>>(){

        @Override
        public Map.Entry<Integer, V> apply(K id, Map.Entry<Integer, V> entry) {
            return entry != null ? new AbstractMap.SimpleImmutableEntry(entry.getKey() + 1, entry.getValue()) : new VolatileEntry(new Integer(0));
        }
    };
    private final Consumer<V> createTask;
    private final BiFunction<K, Map.Entry<Integer, V>, Map.Entry<Integer, V>> removeFunction;

    public ConcurrentManager(Consumer<V> createTask, final Consumer<V> closeTask) {
        this.createTask = createTask;
        this.removeFunction = new BiFunction<K, Map.Entry<Integer, V>, Map.Entry<Integer, V>>(){

            @Override
            public Map.Entry<Integer, V> apply(K key, Map.Entry<Integer, V> entry) {
                int count = entry.getKey();
                Object value = entry.getValue();
                if (count == 0) {
                    if (value != null) {
                        closeTask.accept(value);
                    }
                    return null;
                }
                return new AbstractMap.SimpleImmutableEntry(count - 1, value);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V apply(final K key, Function<Runnable, V> factory) {
        Map.Entry<Integer, V> entry = this.objects.compute(key, this.addFunction);
        if (entry.getValue() == null) {
            Map.Entry<Integer, V> entry2 = entry;
            synchronized (entry2) {
                if (entry.getValue() == null) {
                    final Map<K, Map.Entry<Integer, V>> objects = this.objects;
                    final BiFunction<K, Map.Entry<Integer, V>, Map.Entry<Integer, V>> removeFunction = this.removeFunction;
                    Runnable closeTask = new Runnable(){

                        @Override
                        public void run() {
                            objects.compute(key, removeFunction);
                        }
                    };
                    V value = factory.apply(closeTask);
                    if (value != null) {
                        this.createTask.accept(value);
                        entry.setValue(value);
                    } else {
                        closeTask.run();
                    }
                }
            }
        }
        return entry.getValue();
    }

    private static class VolatileEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private volatile V value;

        VolatileEntry(K key) {
            this(key, null);
        }

        VolatileEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V previous = this.value;
            this.value = value;
            return previous;
        }
    }
}

