/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.deployment.scanner.DeploymentScannerDefinition;
import org.jboss.as.server.deployment.scanner.DeploymentScannerService;
import org.jboss.as.server.deployment.scanner.api.DeploymentScanner;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

final class UpdateScannerWriteAttributeHandler
extends AbstractWriteAttributeHandler<DeploymentScanner> {
    UpdateScannerWriteAttributeHandler() {
        super(new AttributeDefinition[]{DeploymentScannerDefinition.AUTO_DEPLOY_EXPLODED, DeploymentScannerDefinition.AUTO_DEPLOY_XML, DeploymentScannerDefinition.AUTO_DEPLOY_ZIPPED, DeploymentScannerDefinition.DEPLOYMENT_TIMEOUT, DeploymentScannerDefinition.RUNTIME_FAILURE_CAUSES_ROLLBACK, DeploymentScannerDefinition.SCAN_ENABLED, DeploymentScannerDefinition.SCAN_INTERVAL});
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<DeploymentScanner> handbackHolder) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        ServiceController controller = context.getServiceRegistry(true).getRequiredService(DeploymentScannerService.getServiceName(name));
        if (controller.getState() == ServiceController.State.UP) {
            DeploymentScanner scanner = (DeploymentScanner)controller.getValue();
            this.updateScanner(attributeName, scanner, resolvedValue);
            handbackHolder.setHandback((Object)scanner);
        }
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, DeploymentScanner handback) throws OperationFailedException {
        if (handback != null) {
            this.updateScanner(attributeName, handback, context.resolveExpressions(valueToRestore));
        }
    }

    private void updateScanner(String attributeName, DeploymentScanner scanner, ModelNode resolvedNewValue) {
        AttributeDefinition ad = this.getAttributeDefinition(attributeName);
        if (ad == DeploymentScannerDefinition.AUTO_DEPLOY_EXPLODED) {
            scanner.setAutoDeployExplodedContent(resolvedNewValue.asBoolean());
        } else if (ad == DeploymentScannerDefinition.AUTO_DEPLOY_XML) {
            scanner.setAutoDeployXMLContent(resolvedNewValue.asBoolean());
        } else if (ad == DeploymentScannerDefinition.AUTO_DEPLOY_ZIPPED) {
            scanner.setAutoDeployZippedContent(resolvedNewValue.asBoolean());
        } else if (ad == DeploymentScannerDefinition.DEPLOYMENT_TIMEOUT) {
            scanner.setDeploymentTimeout(resolvedNewValue.asLong());
        } else if (ad == DeploymentScannerDefinition.RUNTIME_FAILURE_CAUSES_ROLLBACK) {
            scanner.setRuntimeFailureCausesRollback(resolvedNewValue.asBoolean());
        } else if (ad == DeploymentScannerDefinition.SCAN_INTERVAL) {
            scanner.setScanInterval(resolvedNewValue.asInt());
        } else if (ad == DeploymentScannerDefinition.SCAN_ENABLED) {
            boolean enable = resolvedNewValue.asBoolean();
            if (enable) {
                scanner.startScanner();
            } else {
                scanner.stopScanner();
            }
        } else {
            throw new IllegalStateException();
        }
    }
}

