/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.federation;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class FederationConnectionConfiguration
implements Serializable {
    public static long DEFAULT_CIRCUIT_BREAKER_TIMEOUT = 30000L;
    private boolean isHA;
    private String discoveryGroupName;
    private List<String> staticConnectors;
    private int priorityAdjustment;
    private long circuitBreakerTimeout = DEFAULT_CIRCUIT_BREAKER_TIMEOUT;
    private String username;
    private String password;

    public String getDiscoveryGroupName() {
        return this.discoveryGroupName;
    }

    public FederationConnectionConfiguration setDiscoveryGroupName(String discoveryGroupName) {
        this.discoveryGroupName = discoveryGroupName;
        return this;
    }

    public List<String> getStaticConnectors() {
        return this.staticConnectors;
    }

    public FederationConnectionConfiguration setStaticConnectors(List<String> staticConnectors) {
        this.staticConnectors = staticConnectors;
        return this;
    }

    public boolean isHA() {
        return this.isHA;
    }

    public FederationConnectionConfiguration setHA(boolean HA) {
        this.isHA = HA;
        return this;
    }

    public long getCircuitBreakerTimeout() {
        return this.circuitBreakerTimeout;
    }

    public FederationConnectionConfiguration setCircuitBreakerTimeout(long circuitBreakerTimeout) {
        this.circuitBreakerTimeout = circuitBreakerTimeout;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public FederationConnectionConfiguration setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public FederationConnectionConfiguration setPassword(String password) {
        this.password = password;
        return this;
    }

    public int getPriorityAdjustment() {
        return this.priorityAdjustment;
    }

    public FederationConnectionConfiguration setPriorityAdjustment(int priorityAdjustment) {
        this.priorityAdjustment = priorityAdjustment;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FederationConnectionConfiguration)) {
            return false;
        }
        FederationConnectionConfiguration that = (FederationConnectionConfiguration)o;
        return this.isHA == that.isHA && this.circuitBreakerTimeout == that.circuitBreakerTimeout && Objects.equals(this.discoveryGroupName, that.discoveryGroupName) && Objects.equals(this.staticConnectors, that.staticConnectors) && Objects.equals(this.priorityAdjustment, that.priorityAdjustment) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password);
    }

    public int hashCode() {
        return Objects.hash(this.isHA, this.discoveryGroupName, this.staticConnectors, this.priorityAdjustment, this.circuitBreakerTimeout, this.username, this.password);
    }
}

