/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.irac.IracEntryVersion;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.impl.AbstractIracLocalSiteInterceptor;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.metadata.impl.PrivateMetadata;

public abstract class AbstractIracRemoteSiteInterceptor
extends AbstractIracLocalSiteInterceptor {
    protected void validateOnPrimary(InvocationContext ctx, DataWriteCommand command, Object rv) {
        Object key = command.getKey();
        CacheEntry entry = ctx.lookupEntry(key);
        IracMetadata remoteMetadata = command.getInternalMetadata(key).iracMetadata();
        IracMetadata localMetadata = this.getIracMetadata(entry);
        if (localMetadata == null) {
            localMetadata = this.iracVersionGenerator.getTombstone(key);
        }
        assert (remoteMetadata != null);
        this.iracVersionGenerator.updateVersion(this.getSegment(command, key), remoteMetadata.getVersion());
        if (localMetadata != null) {
            this.validateAndSetMetadata(entry, command, localMetadata, remoteMetadata);
        } else {
            this.setIracMetadata(entry, remoteMetadata);
        }
    }

    protected void setIracMetadataForOwner(InvocationContext ctx, DataWriteCommand command, Object rv) {
        Object key = command.getKey();
        IracMetadata metadata = command.getInternalMetadata(key).iracMetadata();
        assert (metadata != null);
        this.iracVersionGenerator.updateVersion(this.getSegment(command, key), metadata.getVersion());
        this.setIracMetadata(ctx.lookupEntry(key), metadata);
    }

    private void validateAndSetMetadata(CacheEntry<?, ?> entry, DataWriteCommand command, IracMetadata localMetadata, IracMetadata remoteMetadata) {
        if (this.isTraceEnabled()) {
            this.getLog().tracef("[IRAC] Comparing local and remote metadata: %s and %s", localMetadata, remoteMetadata);
        }
        IracEntryVersion localVersion = localMetadata.getVersion();
        IracEntryVersion remoteVersion = remoteMetadata.getVersion();
        switch (remoteVersion.compareTo(localVersion)) {
            case CONFLICTING: {
                this.resolveConflict(entry, command, localMetadata, remoteMetadata);
                return;
            }
            case EQUAL: 
            case BEFORE: {
                this.discardUpdate(entry, command, remoteMetadata);
                return;
            }
        }
        this.setIracMetadata(entry, remoteMetadata);
    }

    private void resolveConflict(CacheEntry<?, ?> entry, DataWriteCommand command, IracMetadata localMetadata, IracMetadata remoteMetadata) {
        if (this.isTraceEnabled()) {
            this.getLog().tracef("[IRAC] Conflict found between local and remote metadata: %s and %s", localMetadata, remoteMetadata);
        }
        assert (!localMetadata.getSite().equals(remoteMetadata.getSite()));
        if (localMetadata.getSite().compareTo(remoteMetadata.getSite()) < 0) {
            this.discardUpdate(entry, command, remoteMetadata);
            return;
        }
        this.setIracMetadata(entry, remoteMetadata);
    }

    private void discardUpdate(CacheEntry<?, ?> entry, DataWriteCommand command, IracMetadata metadata) {
        Object key = entry.getKey();
        this.logUpdateDiscarded(key, metadata);
        assert (metadata != null) : "[IRAC] Metadata must not be null!";
        command.fail();
        entry.setChanged(false);
    }

    private void logUpdateDiscarded(Object key, IracMetadata metadata) {
        if (this.isTraceEnabled()) {
            this.getLog().tracef("[IRAC] Update from remote site discarded. Metadata=%s, key=%s", metadata, key);
        }
    }

    private IracMetadata getIracMetadata(CacheEntry<?, ?> entry) {
        PrivateMetadata privateMetadata = entry.getInternalMetadata();
        if (privateMetadata == null) {
            return this.iracVersionGenerator.getTombstone(entry.getKey());
        }
        IracMetadata metadata = privateMetadata.iracMetadata();
        return metadata == null ? this.iracVersionGenerator.getTombstone(entry.getKey()) : metadata;
    }
}

