/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.AddStepHandlerDescriptor;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.ReloadRequiredResourceRegistration;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.SimpleAliasEntry;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.mod_cluster.CustomLoadMetricResourceDefinition;
import org.wildfly.extension.mod_cluster.LoadMetricResourceDefinition;
import org.wildfly.extension.mod_cluster.ModClusterExtension;
import org.wildfly.extension.mod_cluster.ModClusterModel;

public class DynamicLoadProviderResourceDefinition
extends ChildResourceDefinition<ManagementResourceRegistration> {
    public static final PathElement LEGACY_PATH = PathElement.pathElement((String)"dynamic-load-provider", (String)"configuration");
    public static final PathElement PATH = PathElement.pathElement((String)"load-provider", (String)"dynamic");

    DynamicLoadProviderResourceDefinition() {
        super(PATH, ModClusterExtension.SUBSYSTEM_RESOLVER.createChildResolver(new PathElement[]{PATH}));
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        parent.registerAlias(LEGACY_PATH, (AliasEntry)new SimpleAliasEntry(registration));
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class);
        new LoadMetricResourceDefinition().register(registration);
        new CustomLoadMetricResourceDefinition().register(registration);
        new ReloadRequiredResourceRegistration((AddStepHandlerDescriptor)descriptor).register(registration);
        return registration;
    }

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder;
        ResourceTransformationDescriptionBuilder resourceTransformationDescriptionBuilder = builder = ModClusterModel.VERSION_6_0_0.requiresTransformation(version) ? parent.addChildRedirection(PATH, LEGACY_PATH) : parent.addChildResource(PATH);
        if (ModClusterModel.VERSION_6_0_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setValueConverter((AttributeConverter)new AttributeConverter.DefaultAttributeConverter(){

                protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                    if (attributeValue.isDefined() && attributeValue.getType() != ModelType.EXPRESSION) {
                        attributeValue.set((int)Math.ceil(attributeValue.asDouble()));
                    }
                }
            }, new AttributeDefinition[]{Attribute.DECAY.getDefinition()})).end();
        }
        if (ModClusterModel.VERSION_7_0_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(-1)}), new AttributeDefinition[]{Attribute.INITIAL_LOAD.getDefinition()})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{Attribute.INITIAL_LOAD.getDefinition()})).end();
        }
        LoadMetricResourceDefinition.buildTransformation(version, builder);
        CustomLoadMetricResourceDefinition.buildTransformation(version, builder);
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        DECAY("decay", ModelType.DOUBLE, new ModelNode(2.0)),
        HISTORY("history", ModelType.INT, new ModelNode(9)),
        INITIAL_LOAD("initial-load", ModelType.INT, ModelNode.ZERO){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder simpleAttributeDefinitionBuilder) {
                return (SimpleAttributeDefinitionBuilder)simpleAttributeDefinitionBuilder.setValidator((ParameterValidator)new IntRangeValidator(-1, 100, true, true));
            }
        };

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setRestartAllServices()).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return builder;
        }
    }
}

