/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.opentracing;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.microprofile.opentracing.SubsystemDefinition;
import org.wildfly.extension.microprofile.opentracing.TracingDependencyProcessor;
import org.wildfly.extension.microprofile.opentracing.TracingDeploymentProcessor;
import org.wildfly.extension.microprofile.opentracing.TracingExtensionLogger;
import org.wildfly.extension.microprofile.opentracing.resolver.JaegerEnvTracerConfiguration;
import org.wildfly.microprofile.opentracing.smallrye.TracerConfiguration;
import org.wildfly.microprofile.opentracing.smallrye.WildFlyTracerFactory;

class SubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static final SubsystemAdd INSTANCE = new SubsystemAdd();

    private SubsystemAdd() {
        super(new AttributeDefinition[]{SubsystemDefinition.DEFAULT_TRACER});
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        WildFlyTracerFactory.registerTracer((String)"org.wildfly.microprofile.opentracing.env-tracer").accept(new JaegerEnvTracerConfiguration());
        TracingExtensionLogger.ROOT_LOGGER.activatingSubsystem();
        String defaultTracer = SubsystemDefinition.DEFAULT_TRACER.resolveModelAttribute(context, operation).asStringOrNull();
        if (defaultTracer != null && !defaultTracer.isEmpty()) {
            CapabilityServiceBuilder builder = context.getCapabilityServiceTarget().addCapability(SubsystemDefinition.DEFAULT_TRACER_CAPABILITY);
            final Supplier config = builder.requiresCapability("org.wildfly.microprofile.opentracing.tracer", TracerConfiguration.class, new String[]{defaultTracer});
            final Consumer injector = builder.provides(new RuntimeCapability[]{SubsystemDefinition.DEFAULT_TRACER_CAPABILITY});
            builder.setInstance(new Service(){

                public void start(StartContext context) throws StartException {
                    injector.accept(config.get());
                    WildFlyTracerFactory.registerDefaultTracer().accept(config.get());
                }

                public void stop(StopContext context) {
                    injector.accept(null);
                    WildFlyTracerFactory.registerDefaultTracer().accept(config.get());
                }
            }).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("microprofile-opentracing-smallrye", Phase.DEPENDENCIES, 6272, (DeploymentUnitProcessor)new TracingDependencyProcessor());
                processorTarget.addDeploymentProcessor("microprofile-opentracing-smallrye", Phase.POST_MODULE, 14208, (DeploymentUnitProcessor)new TracingDeploymentProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        context.registerCapability(SubsystemDefinition.OPENTRACING_CAPABILITY);
        ModelNode defaultTracer = SubsystemDefinition.DEFAULT_TRACER.resolveModelAttribute(context, operation);
        if (defaultTracer.isDefined()) {
            context.registerCapability(SubsystemDefinition.DEFAULT_TRACER_CAPABILITY);
        }
    }
}

