/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller;

import org.jboss.as.controller.RunningMode;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;

public class SlaveRegistrationException
extends Exception {
    private static final String SEPARATOR = "-$-";
    private final ErrorCode errorCode;
    private final String errorMessage;

    public SlaveRegistrationException(ErrorCode errorCode, String errorMessage) {
        super(errorMessage);
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public static SlaveRegistrationException parse(String raw) {
        int index = raw.indexOf(SEPARATOR);
        if (index == -1) {
            return new SlaveRegistrationException(ErrorCode.UNKNOWN, raw);
        }
        ErrorCode code = ErrorCode.parseCode(Byte.valueOf(raw.substring(0, index)));
        String msg = raw.substring(index + SEPARATOR.length());
        return new SlaveRegistrationException(code, msg);
    }

    public static SlaveRegistrationException forUnknownError(String msg) {
        return new SlaveRegistrationException(ErrorCode.UNKNOWN, msg);
    }

    public static SlaveRegistrationException forHostAlreadyExists(String slaveName) {
        return new SlaveRegistrationException(ErrorCode.HOST_ALREADY_EXISTS, DomainControllerLogger.ROOT_LOGGER.slaveAlreadyRegistered(slaveName));
    }

    public static SlaveRegistrationException forMasterInAdminOnlyMode(RunningMode runningMode) {
        return new SlaveRegistrationException(ErrorCode.MASTER_IS_ADMIN_ONLY, DomainControllerLogger.ROOT_LOGGER.adminOnlyModeCannotAcceptSlaves(runningMode));
    }

    public static SlaveRegistrationException forHostIsNotMaster() {
        return new SlaveRegistrationException(ErrorCode.HOST_ALREADY_EXISTS, DomainControllerLogger.ROOT_LOGGER.slaveControllerCannotAcceptOtherSlaves());
    }

    public String marshal() {
        return this.errorCode.getCode() + SEPARATOR + this.errorMessage;
    }

    @Override
    public String toString() {
        return this.errorCode.getCode() + SEPARATOR + this.errorMessage;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static enum ErrorCode {
        UNKNOWN(1),
        HOST_ALREADY_EXISTS(2),
        MASTER_IS_ADMIN_ONLY(3),
        HOST_IS_NOT_MASTER(4),
        INCOMPATIBLE_VERSION(5);

        private final byte code;

        private ErrorCode(int code) {
            this.code = (byte)code;
        }

        public byte getCode() {
            return this.code;
        }

        public static ErrorCode parseCode(byte code) {
            if (code == UNKNOWN.getCode()) {
                return UNKNOWN;
            }
            if (code == HOST_ALREADY_EXISTS.getCode()) {
                return HOST_ALREADY_EXISTS;
            }
            if (code == MASTER_IS_ADMIN_ONLY.getCode()) {
                return MASTER_IS_ADMIN_ONLY;
            }
            if (code == HOST_IS_NOT_MASTER.getCode()) {
                return HOST_IS_NOT_MASTER;
            }
            if (code == INCOMPATIBLE_VERSION.getCode()) {
                return INCOMPATIBLE_VERSION;
            }
            return UNKNOWN;
        }
    }
}

