/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.impl.WireFormat;
import org.wildfly.clustering.marshalling.protostream.FunctionalObjectMarshaller;
import org.wildfly.clustering.marshalling.protostream.MarshallerProvider;
import org.wildfly.clustering.marshalling.protostream.Predictable;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;

public enum OptionalMarshaller implements MarshallerProvider
{
    INT((Class)OptionalInt.class){

        @Override
        public OptionalInt readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            OptionalInt result = OptionalInt.empty();
            int tag = reader.readTag();
            while (tag != 0) {
                int field = WireFormat.getTagFieldNumber((int)tag);
                switch (field) {
                    case 1: {
                        result = OptionalInt.of(reader.readSInt32());
                        break;
                    }
                    default: {
                        reader.skipField(tag);
                    }
                }
                tag = reader.readTag();
            }
            return result;
        }

        @Override
        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Object value) throws IOException {
            OptionalInt optional = (OptionalInt)value;
            if (optional.isPresent()) {
                writer.writeSInt64(1, (long)optional.getAsInt());
            }
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Object value) {
            OptionalInt optional = (OptionalInt)value;
            return OptionalInt.of(optional.isPresent() ? Predictable.signedIntSize(optional.getAsInt()) + 1 : 0);
        }
    }
    ,
    LONG((Class)OptionalLong.class){

        @Override
        public OptionalLong readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            OptionalLong result = OptionalLong.empty();
            int tag = reader.readTag();
            while (tag != 0) {
                int field = WireFormat.getTagFieldNumber((int)tag);
                switch (field) {
                    case 1: {
                        result = OptionalLong.of(reader.readSInt64());
                        break;
                    }
                    default: {
                        reader.skipField(tag);
                    }
                }
                tag = reader.readTag();
            }
            return result;
        }

        @Override
        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Object value) throws IOException {
            OptionalLong optional = (OptionalLong)value;
            if (optional.isPresent()) {
                writer.writeSInt64(1, optional.getAsLong());
            }
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Object value) {
            OptionalLong optional = (OptionalLong)value;
            return OptionalInt.of(optional.isPresent() ? Predictable.signedLongSize(optional.getAsLong()) + 1 : 0);
        }
    }
    ,
    DOUBLE((Class)OptionalDouble.class){

        @Override
        public OptionalDouble readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            OptionalDouble result = OptionalDouble.empty();
            int tag = reader.readTag();
            while (tag != 0) {
                int field = WireFormat.getTagFieldNumber((int)tag);
                switch (field) {
                    case 1: {
                        result = OptionalDouble.of(reader.readDouble());
                        break;
                    }
                    default: {
                        reader.skipField(tag);
                    }
                }
                tag = reader.readTag();
            }
            return result;
        }

        @Override
        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Object value) throws IOException {
            OptionalDouble optional = (OptionalDouble)value;
            if (optional.isPresent()) {
                writer.writeDouble(1, optional.getAsDouble());
            }
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Object value) {
            OptionalDouble optional = (OptionalDouble)value;
            return OptionalInt.of(optional.isPresent() ? 9 : 0);
        }
    }
    ,
    OBJECT((Class)Optional.class){
        private final ProtoStreamMarshaller<Optional> marshaller = new FunctionalObjectMarshaller<Optional>(Optional.class, Optional::ofNullable, value -> value.orElse(null));

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return this.marshaller;
        }
    };

    private final Class<?> targetClass;

    private OptionalMarshaller(Class<?> targetClass) {
        this.targetClass = targetClass;
    }

    @Override
    public Class<? extends Object> getJavaClass() {
        return this.targetClass;
    }

    @Override
    public ProtoStreamMarshaller<?> getMarshaller() {
        return this;
    }
}

