/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.EnumSet;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.LongRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.TimeUnitValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.ejb3.component.pool.StrictMaxPoolConfig;
import org.jboss.as.ejb3.component.pool.StrictMaxPoolConfigService;
import org.jboss.as.ejb3.subsystem.EJB3Extension;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemModel;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemXMLAttribute;
import org.jboss.as.ejb3.subsystem.StrictMaxPoolAdd;
import org.jboss.as.ejb3.subsystem.StrictMaxPoolDerivedSizeReadHandler;
import org.jboss.as.ejb3.subsystem.StrictMaxPoolWriteHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class StrictMaxPoolResourceDefinition
extends SimpleResourceDefinition {
    public static final String STRICT_MAX_POOL_CONFIG_CAPABILITY_NAME = "org.wildfly.ejb3.pool-config";
    public static final RuntimeCapability<Void> STRICT_MAX_POOL_CONFIG_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.ejb3.pool-config", (boolean)true, StrictMaxPoolConfigService.class).build();
    public static final SimpleAttributeDefinition MAX_POOL_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-pool-size", ModelType.INT, true).setDefaultValue(new ModelNode().set(20))).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(1, Integer.MAX_VALUE, true, true))).setAlternatives(new String[]{"derive-size"})).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_NONE})).build();
    public static final SimpleAttributeDefinition DERIVE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("derive-size", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)EnumValidator.create(DeriveSize.class, (boolean)true, (boolean)false, (Enum[])DeriveSize.access$000()))).setCorrector((newValue, currentValue) -> newValue.getType() == ModelType.STRING && DeriveSize.NONE.toString().equalsIgnoreCase(newValue.asString()) ? new ModelNode() : newValue)).setAlternatives(new String[]{"max-pool-size"})).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_NONE})).build();
    public static final SimpleAttributeDefinition INSTANCE_ACQUISITION_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("timeout", ModelType.LONG, true).setXmlName(EJB3SubsystemXMLAttribute.INSTANCE_ACQUISITION_TIMEOUT.getLocalName())).setDefaultValue(new ModelNode().set(5L))).setAllowExpression(true)).setValidator((ParameterValidator)new LongRangeValidator(1L, Integer.MAX_VALUE, true, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_NONE})).build();
    public static final SimpleAttributeDefinition INSTANCE_ACQUISITION_TIMEOUT_UNIT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("timeout-unit", ModelType.STRING, true).setXmlName(EJB3SubsystemXMLAttribute.INSTANCE_ACQUISITION_TIMEOUT_UNIT.getLocalName())).setValidator((ParameterValidator)new TimeUnitValidator(true, true))).setDefaultValue(new ModelNode().set(StrictMaxPoolConfig.DEFAULT_TIMEOUT_UNIT.name()))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_NONE})).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition DERIVED_SIZE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("derived-size", ModelType.INT, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{MAX_POOL_SIZE, DERIVE_SIZE, INSTANCE_ACQUISITION_TIMEOUT, INSTANCE_ACQUISITION_TIMEOUT_UNIT};
    private static final StrictMaxPoolAdd ADD_HANDLER = new StrictMaxPoolAdd(ATTRIBUTES);
    public static final StrictMaxPoolResourceDefinition INSTANCE = new StrictMaxPoolResourceDefinition();
    private static final String NONE_VALUE = "none";
    private static final String FROM_WORKER_POOLS_VALUE = "from-worker-pools";
    private static final String FROM_CPU_COUNT_VALUE = "from-cpu-count";

    static StrictMaxPoolConfigService.Derive parseDeriveSize(OperationContext context, ModelNode strictMaxPoolModel) throws OperationFailedException {
        ModelNode dsNode = DERIVE_SIZE.resolveModelAttribute(context, strictMaxPoolModel);
        if (dsNode.isDefined()) {
            DeriveSize deriveSize = DeriveSize.fromValue(dsNode.asString());
            switch (deriveSize) {
                case FROM_WORKER_POOLS: {
                    return StrictMaxPoolConfigService.Derive.FROM_WORKER_POOLS;
                }
                case FROM_CPU_COUNT: {
                    return StrictMaxPoolConfigService.Derive.FROM_CPU_COUNT;
                }
            }
        }
        return StrictMaxPoolConfigService.Derive.NONE;
    }

    private StrictMaxPoolResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(EJB3SubsystemModel.STRICT_MAX_BEAN_INSTANCE_POOL_PATH, EJB3Extension.getResourceDescriptionResolver("strict-max-bean-instance-pool")).setAddHandler((OperationStepHandler)ADD_HANDLER).setRemoveHandler((OperationStepHandler)new ServiceRemoveStepHandler(null, (AbstractAddStepHandler)ADD_HANDLER, new RuntimeCapability[]{STRICT_MAX_POOL_CONFIG_CAPABILITY})).setAddRestartLevel(OperationEntry.Flag.RESTART_NONE).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{STRICT_MAX_POOL_CONFIG_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        StrictMaxPoolWriteHandler osh = new StrictMaxPoolWriteHandler(ATTRIBUTES);
        for (AttributeDefinition attr : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)osh);
        }
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)DERIVED_SIZE, (OperationStepHandler)new StrictMaxPoolDerivedSizeReadHandler());
    }

    static enum DeriveSize {
        NONE("none"),
        FROM_WORKER_POOLS("from-worker-pools"),
        FROM_CPU_COUNT("from-cpu-count");

        private static DeriveSize[] LEGAL_VALUES;
        private String value;

        private DeriveSize(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static DeriveSize fromValue(String value) {
            switch (value) {
                case "none": {
                    return NONE;
                }
                case "from-worker-pools": {
                    return FROM_WORKER_POOLS;
                }
                case "from-cpu-count": {
                    return FROM_CPU_COUNT;
                }
            }
            return DeriveSize.valueOf(value);
        }

        static /* synthetic */ DeriveSize[] access$000() {
            return LEGAL_VALUES;
        }

        static {
            LEGAL_VALUES = EnumSet.complementOf(EnumSet.of(NONE)).toArray(new DeriveSize[2]);
        }
    }
}

