/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.connections.ldap;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionAddHandler;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionManagerService;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class LdapConnectionWriteAttributeHandler
extends AbstractWriteAttributeHandler<LdapConnectionManagerService.Config> {
    public LdapConnectionWriteAttributeHandler() {
        super(LdapConnectionResourceDefinition.ATTRIBUTE_DEFINITIONS);
    }

    void registerAttributes(ManagementResourceRegistration registration) {
        for (AttributeDefinition attr : LdapConnectionResourceDefinition.ATTRIBUTE_DEFINITIONS) {
            registration.registerReadWriteAttribute(attr, null, (OperationStepHandler)this);
        }
    }

    protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource resource) throws OperationFailedException {
        super.finishModelStage(context, operation, attributeName, newValue, oldValue, resource);
        if (attributeName.equals(LdapConnectionResourceDefinition.SEARCH_CREDENTIAL_REFERENCE.getName())) {
            CredentialReference.handleCredentialReferenceUpdate((OperationContext)context, (ModelNode)resource.getModel().get(attributeName), (String)attributeName);
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<LdapConnectionManagerService.Config> handbackHolder) throws OperationFailedException {
        boolean requiresReload = false;
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        if (attributeName.equals(LdapConnectionResourceDefinition.SEARCH_CREDENTIAL_REFERENCE.getName())) {
            requiresReload = CredentialReference.applyCredentialReferenceUpdateToRuntime((OperationContext)context, (ModelNode)operation, (ModelNode)resolvedValue, (ModelNode)currentValue, (String)attributeName);
        }
        handbackHolder.setHandback((Object)this.updateLdapConnectionService(context, operation, model));
        return requiresReload;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, LdapConnectionManagerService.Config handback) throws OperationFailedException {
        if (attributeName.equals(LdapConnectionResourceDefinition.SEARCH_CREDENTIAL_REFERENCE.getName())) {
            CredentialReference.rollbackCredentialStoreUpdate((AttributeDefinition)LdapConnectionResourceDefinition.SEARCH_CREDENTIAL_REFERENCE, (OperationContext)context, (ModelNode)valueToRevert);
        }
        this.updateLdapConnectionService(context, operation, handback);
    }

    private LdapConnectionManagerService.Config updateLdapConnectionService(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        ServiceName svcName = LdapConnectionManagerService.ServiceUtil.createServiceName(name);
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController controller = registry.getService(svcName);
        if (controller != null) {
            LdapConnectionManagerService service = (LdapConnectionManagerService)LdapConnectionManagerService.class.cast(controller.getValue());
            return LdapConnectionAddHandler.updateRuntime(context, model, service);
        }
        return null;
    }

    private void updateLdapConnectionService(OperationContext context, ModelNode operation, LdapConnectionManagerService.Config config) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        ServiceName svcName = LdapConnectionManagerService.ServiceUtil.createServiceName(name);
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController controller = registry.getService(svcName);
        if (controller != null) {
            LdapConnectionManagerService service = (LdapConnectionManagerService)LdapConnectionManagerService.class.cast(controller.getValue());
            service.setConfiguration(config);
        }
    }
}

