/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.ComponentServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.ExpirationResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.ServiceConfigurator;

public class ExpirationServiceConfigurator
extends ComponentServiceConfigurator<ExpirationConfiguration> {
    private volatile long interval;
    private volatile long lifespan;
    private volatile long maxIdle;

    ExpirationServiceConfigurator(PathAddress address) {
        super(CacheComponent.EXPIRATION, address);
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.interval = ExpirationResourceDefinition.Attribute.INTERVAL.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        this.lifespan = ExpirationResourceDefinition.Attribute.LIFESPAN.resolveModelAttribute((ExpressionResolver)context, model).asLong(-1L);
        this.maxIdle = ExpirationResourceDefinition.Attribute.MAX_IDLE.resolveModelAttribute((ExpressionResolver)context, model).asLong(-1L);
        return this;
    }

    @Override
    public ExpirationConfiguration get() {
        return new ConfigurationBuilder().expiration().lifespan(this.lifespan, TimeUnit.MILLISECONDS).maxIdle(this.maxIdle, TimeUnit.MILLISECONDS).reaperEnabled(this.lifespan > 0L || this.maxIdle > 0L).wakeUpInterval(this.interval, TimeUnit.MILLISECONDS).create();
    }
}

