/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.LinkedHashSet;
import java.util.Set;
import org.infinispan.commons.configuration.attributes.AttributeSet;

class AttributeChangeTracker {
    private boolean isTracking = true;
    private final Set<String> changedAttributes = new LinkedHashSet<String>();

    AttributeChangeTracker(AttributeSet attributeSet) {
        attributeSet.attributes().forEach(a -> a.addListener((attr, oldVal) -> {
            if (this.isTracking) {
                String name = attr.name();
                Object value = attr.get();
                this.changedAttributes.add(name + "=" + (value == null ? "" : value.toString()));
            }
        }));
    }

    void stopChangeTracking() {
        this.isTracking = false;
    }

    boolean hasChanges() {
        return !this.changedAttributes.isEmpty();
    }

    void reset() {
        this.changedAttributes.clear();
        this.isTracking = true;
    }

    String getChangedAttributes() {
        return String.join((CharSequence)", ", this.changedAttributes);
    }
}

