/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning.irac;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.container.versioning.irac.IracEntryVersion;
import org.infinispan.container.versioning.irac.IracVersionGenerator;
import org.infinispan.container.versioning.irac.TopologyIracVersion;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.topology.CacheTopology;

@Scope(value=Scopes.NAMED_CACHE)
public class DefaultIracVersionGenerator
implements IracVersionGenerator {
    private final Map<Integer, Map<String, TopologyIracVersion>> segmentVersion = new ConcurrentHashMap<Integer, Map<String, TopologyIracVersion>>();
    private final Map<Object, IracMetadata> tombstone = new ConcurrentHashMap<Object, IracMetadata>();
    @Inject
    Transport transport;
    private String localSite;
    private volatile int topologyId;

    @Start
    public void start() {
        this.transport.checkCrossSiteAvailable();
        this.localSite = this.transport.localSiteName();
    }

    public void stop() {
    }

    @Override
    public IracMetadata generateNewMetadata(int segment) {
        Map v = this.segmentVersion.compute(segment, this::generateNewVectorFunction);
        return new IracMetadata(this.localSite, new IracEntryVersion(v));
    }

    @Override
    public void updateVersion(int segment, IracEntryVersion remoteVersion) {
        this.segmentVersion.merge(segment, remoteVersion.toMap(), this::mergeVectorsFunction);
    }

    @Override
    public void onTopologyChange(CacheTopology newTopology) {
        this.topologyId = newTopology.getTopologyId();
    }

    @Override
    public void storeTombstone(Object key, IracMetadata metadata) {
        this.tombstone.put(key, metadata);
    }

    @Override
    public void storeTombstoneIfAbsent(Object key, IracMetadata metadata) {
        if (metadata == null) {
            return;
        }
        this.tombstone.putIfAbsent(key, metadata);
    }

    @Override
    public IracMetadata getTombstone(Object key) {
        return this.tombstone.get(key);
    }

    @Override
    public void removeTombstone(Object key, IracMetadata iracMetadata) {
        if (iracMetadata == null) {
            return;
        }
        this.tombstone.remove(key, iracMetadata);
    }

    @Override
    public void removeTombstone(Object key) {
        this.tombstone.remove(key);
    }

    private Map<String, TopologyIracVersion> generateNewVectorFunction(Integer s, Map<String, TopologyIracVersion> versions) {
        if (versions == null) {
            return Collections.singletonMap(this.localSite, TopologyIracVersion.newVersion(this.topologyId));
        }
        HashMap<String, TopologyIracVersion> copy = new HashMap<String, TopologyIracVersion>(versions);
        copy.compute(this.localSite, this::incrementVersionFunction);
        return copy;
    }

    private TopologyIracVersion incrementVersionFunction(String site, TopologyIracVersion version) {
        return version == null ? TopologyIracVersion.newVersion(this.topologyId) : version.increment(this.topologyId);
    }

    private Map<String, TopologyIracVersion> mergeVectorsFunction(Map<String, TopologyIracVersion> v1, Map<String, TopologyIracVersion> v2) {
        if (v1 == null) {
            return v2;
        }
        HashMap<String, TopologyIracVersion> copy = new HashMap<String, TopologyIracVersion>(v1);
        for (Map.Entry<String, TopologyIracVersion> entry : v2.entrySet()) {
            copy.merge(entry.getKey(), entry.getValue(), TopologyIracVersion::max);
        }
        return copy;
    }
}

