/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.upgrade;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.Parameter;
import org.infinispan.upgrade.SourceMigrator;
import org.infinispan.upgrade.TargetMigrator;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="RollingUpgradeManager", description="Handles the migration of data when upgrading between versions.")
@Scope(value=Scopes.NAMED_CACHE)
@SurvivesRestarts
public class RollingUpgradeManager {
    private static final Log log = LogFactory.getLog(RollingUpgradeManager.class);
    private final Set<SourceMigrator> sourceMigrators = new HashSet<SourceMigrator>(2);
    @Inject
    Cache<Object, Object> cache;
    @Inject
    TimeService timeService;
    @Inject
    GlobalConfiguration globalConfiguration;

    @ManagedOperation(description="Synchronizes data from source clusters to target clusters with the specified migrator.", displayName="Synchronizes data from source clusters to target clusters with the specified migrator.")
    public long synchronizeData(@Parameter(name="migratorName", description="Specifies the name of the migrator to use. Set hotrod as the value unless using custom migrators.") String migratorName) throws Exception {
        TargetMigrator migrator = this.getMigrator(migratorName);
        long start = this.timeService.time();
        long count = migrator.synchronizeData(this.cache);
        log.entriesMigrated(count, this.cache.getName(), Util.prettyPrintTime((long)this.timeService.timeDuration(start, TimeUnit.MILLISECONDS)));
        return count;
    }

    @ManagedOperation(description="Synchronizes data from source clusters to target clusters with the specified migrator.", displayName="Synchronizes data from source clusters to target clusters with the specified migrator.")
    public long synchronizeData(@Parameter(name="migratorName", description="Specifies the name of the migrator to use. Set hotrod as the value unless using custom migrators.") String migratorName, @Parameter(name="readBatch", description="Specifies how many entries to read at a time from source clusters. Default is 10000.") int readBatch, @Parameter(name="threads", description="Specifies the number of threads to use per node when writing data to target clusters. Defaults to number of available processors.") int threads) throws Exception {
        TargetMigrator migrator = this.getMigrator(migratorName);
        long start = this.timeService.time();
        long count = migrator.synchronizeData(this.cache, readBatch, threads);
        log.entriesMigrated(count, this.cache.getName(), Util.prettyPrintTime((long)this.timeService.timeDuration(start, TimeUnit.MILLISECONDS)));
        return count;
    }

    @ManagedOperation(description="Disconnects target clusters from source clusters.", displayName="Disconnects target clusters from source clusters.")
    public void disconnectSource(@Parameter(name="migratorName", description="Specifies the name of the migrator to use. Set hotrod as the value unless using custom migrators.") String migratorName) throws Exception {
        TargetMigrator migrator = this.getMigrator(migratorName);
        migrator.disconnectSource(this.cache);
    }

    private TargetMigrator getMigrator(String name) throws Exception {
        ClassLoader cl = this.globalConfiguration.classLoader();
        for (TargetMigrator m : ServiceFinder.load(TargetMigrator.class, (ClassLoader[])new ClassLoader[]{cl})) {
            if (!name.equalsIgnoreCase(m.getName())) continue;
            return m;
        }
        throw Log.CONTAINER.unknownMigrator(name);
    }

    public void addSourceMigrator(SourceMigrator migrator) {
        this.sourceMigrators.add(migrator);
    }
}

