/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.remote.EarlyResponseSendListener;
import org.jboss.as.domain.http.server.ResponseCallback;
import org.jboss.dmr.ModelNode;

final class EarlyResponseTransactionControl
implements ModelController.OperationTransactionControl {
    private final ResponseCallback callback;
    private final boolean reload;

    EarlyResponseTransactionControl(ResponseCallback callback, ModelNode operation) {
        this.callback = callback;
        this.reload = "reload".equals(operation.get("operation").asString());
    }

    public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode preparedResult) {
        this.operationPrepared(transaction, preparedResult, null);
    }

    public void operationPrepared(ModelController.OperationTransaction transaction, final ModelNode preparedResult, OperationContext context) {
        transaction.commit();
        if (context == null || !this.reload) {
            this.sendResponse(preparedResult);
        } else {
            context.attach(EarlyResponseSendListener.ATTACHMENT_KEY, (Object)new EarlyResponseSendListener(){

                public void sendEarlyResponse(OperationContext.ResultAction resultAction) {
                    EarlyResponseTransactionControl.this.sendResponse(preparedResult);
                }
            });
        }
    }

    private void sendResponse(ModelNode preparedResult) {
        preparedResult.get("outcome").set("success");
        preparedResult.get("result");
        this.callback.sendResponse(OperationResponse.Factory.createSimple((ModelNode)preparedResult));
    }
}

