/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate4.management;

public class QueryName {
    private final String hibernateQuery;
    private final String displayQuery;
    private static final String SQL_NE = "<>";
    private static final String NE_BANG = "!=";
    private static final String NE_HAT = "^=";
    private static final String LE = "<=";
    private static final String GE = ">=";
    private static final String CONCAT = "||";
    private static final String LT = "<";
    private static final String EQ = "=";
    private static final String GT = ">";
    private static final String OPEN = "(";
    private static final String CLOSE = ")";
    private static final String OPEN_BRACKET = "[";
    private static final String CLOSE_BRACKET = "]";
    private static final String PLUS = "+";
    private static final String MINUS = "-";
    private static final String STAR = "*";
    private static final String DIV = "/";
    private static final String MOD = "%";
    private static final String COLON = ":";
    private static final String PARAM = "?";
    private static final String COMMA = ",";
    private static final String SPACE = " ";
    private static final String TAB = "\t";
    private static final String NEWLINE = "\n";
    private static final String LINEFEED = "\r";
    private static final String QUOTE = "'";
    private static final String DQUOTE = "\"";
    private static final String TICK = "`";
    private static final String OPEN_BRACE = "{";
    private static final String CLOSE_BRACE = "}";
    private static final String HAT = "^";
    private static final String AMPERSAND = "&";
    private static final String NOT_EQUAL__ = "_not_equal_";
    private static final String BANG_NOT_EQUAL__ = "_bang_not_equal_";
    private static final String HAT_NOT_EQUAL__ = "_hat_not_equal_";
    private static final String LESS_THAN_EQUAL__ = "_less_than_equal_";
    private static final String GREATER_THAN_EQUAL__ = "_greater_than_equal_";
    private static final String CONCAT__ = "_concat_";
    private static final String LESS_THAN__ = "_less_than_";
    private static final String EQUAL__ = "_equal_";
    private static final String GREATER__ = "_greater_";
    private static final String LEFT_PAREN__ = "_left_paren_";
    private static final String RIGHT_PAREN__ = "_right_paren_";
    private static final String LEFT_BRACKET__ = "_left_bracket_";
    private static final String RIGHT_BRACKET__ = "_right_bracket_";
    private static final String PLUS__ = "_plus_";
    private static final String MINUS__ = "_minus_";
    private static final String STAR__ = "_star_";
    private static final String DIVIDE__ = "_divide_";
    private static final String MODULUS__ = "_modulus_";
    private static final String COLON__ = "_colon_";
    private static final String PARAM__ = "_param_";
    private static final String COMMA__ = "_comma_";
    private static final String SPACE__ = "_space_";
    private static final String TAB__ = "_tab_";
    private static final String NEWLINE__ = "_newline_";
    private static final String LINEFEED__ = "_linefeed_";
    private static final String QUOTE__ = "_quote_";
    private static final String DQUOTE__ = "_double_quote_";
    private static final String TICK__ = "_tick_";
    private static final String OPEN_BRACE__ = "_left_brace_";
    private static final String CLOSE_BRACE__ = "_right_brace_";
    private static final String HAT__ = "_hat_";
    private static final String AMPERSAND__ = "_ampersand_";

    public static QueryName queryName(String query) {
        return new QueryName(query);
    }

    public QueryName(String query) {
        this.hibernateQuery = query;
        this.displayQuery = this.displayable(query);
    }

    public String getDisplayName() {
        return this.displayQuery;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryName queryName = (QueryName)o;
        if (this.displayQuery != null ? !this.displayQuery.equals(queryName.displayQuery) : queryName.displayQuery != null) {
            return false;
        }
        return !(this.hibernateQuery != null ? !this.hibernateQuery.equals(queryName.hibernateQuery) : queryName.hibernateQuery != null);
    }

    public int hashCode() {
        int result = this.hibernateQuery != null ? this.hibernateQuery.hashCode() : 0;
        result = 31 * result + (this.displayQuery != null ? this.displayQuery.hashCode() : 0);
        return result;
    }

    private String displayable(String query) {
        if (query == null || query.length() == 0) {
            return query;
        }
        StringBuilder buff = new StringBuilder(query);
        QueryName.subst(buff, SQL_NE, NOT_EQUAL__);
        QueryName.subst(buff, NE_BANG, BANG_NOT_EQUAL__);
        QueryName.subst(buff, NE_HAT, HAT_NOT_EQUAL__);
        QueryName.subst(buff, LE, LESS_THAN_EQUAL__);
        QueryName.subst(buff, GE, GREATER_THAN_EQUAL__);
        QueryName.subst(buff, CONCAT, CONCAT__);
        QueryName.subst(buff, LT, LESS_THAN__);
        QueryName.subst(buff, EQ, EQUAL__);
        QueryName.subst(buff, GT, GREATER__);
        QueryName.subst(buff, OPEN, LEFT_PAREN__);
        QueryName.subst(buff, CLOSE, RIGHT_PAREN__);
        QueryName.subst(buff, OPEN_BRACKET, LEFT_BRACKET__);
        QueryName.subst(buff, CLOSE_BRACKET, RIGHT_BRACKET__);
        QueryName.subst(buff, PLUS, PLUS__);
        QueryName.subst(buff, MINUS, MINUS__);
        QueryName.subst(buff, STAR, STAR__);
        QueryName.subst(buff, DIV, DIVIDE__);
        QueryName.subst(buff, MOD, MODULUS__);
        QueryName.subst(buff, COLON, COLON__);
        QueryName.subst(buff, PARAM, PARAM__);
        QueryName.subst(buff, COMMA, COMMA__);
        QueryName.subst(buff, SPACE, SPACE__);
        QueryName.subst(buff, TAB, TAB__);
        QueryName.subst(buff, NEWLINE, NEWLINE__);
        QueryName.subst(buff, LINEFEED, LINEFEED__);
        QueryName.subst(buff, QUOTE, QUOTE__);
        QueryName.subst(buff, DQUOTE, DQUOTE__);
        QueryName.subst(buff, TICK, TICK__);
        QueryName.subst(buff, OPEN_BRACE, OPEN_BRACE__);
        QueryName.subst(buff, CLOSE_BRACE, CLOSE_BRACE__);
        QueryName.subst(buff, HAT, HAT__);
        QueryName.subst(buff, AMPERSAND, AMPERSAND__);
        return buff.toString();
    }

    private static void subst(StringBuilder stringBuilder, String from, String to) {
        int begin = 0;
        int end = 0;
        while ((end = stringBuilder.indexOf(from, end)) != -1) {
            stringBuilder.delete(end, end + from.length());
            stringBuilder.insert(end, to);
            end = begin = end + to.length();
        }
    }
}

