/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.commons.util.Util;
import org.infinispan.persistence.remote.configuration.Attribute;
import org.infinispan.persistence.remote.configuration.Element;
import org.infinispan.persistence.remote.configuration.SslConfiguration;

public class KeyStoreConfiguration
implements ConfigurationInfo {
    static final AttributeDefinition<String> KEYSTORE_FILENAME = AttributeDefinition.builder((String)"keyStoreFilename", null, String.class).xmlName(Attribute.FILENAME.getLocalName()).immutable().autoPersist(false).build();
    static final AttributeDefinition<String> KEYSTORE_TYPE = AttributeDefinition.builder((String)"keyStoreType", (Object)"JKS", String.class).immutable().autoPersist(false).xmlName(Attribute.TYPE.getLocalName()).build();
    static final AttributeDefinition<String> KEYSTORE_PASSWORD = AttributeDefinition.builder((String)"keyStorePassword", null, String.class).xmlName(Attribute.PASSWORD.getLocalName()).immutable().autoPersist(false).build();
    static final AttributeDefinition<String> KEYSTORE_CERTIFICATE_PASSWORD = AttributeDefinition.builder((String)"keyStoreCertificatePassword", null, String.class).immutable().xmlName(Attribute.CERTIFICATE_PASSWORD.getLocalName()).autoPersist(false).build();
    static final AttributeDefinition<String> KEY_ALIAS = AttributeDefinition.builder((String)"keyAlias", null, String.class).immutable().autoPersist(false).build();
    static final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.KEYSTORE.getLocalName());
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SslConfiguration.class, new AttributeDefinition[]{KEYSTORE_FILENAME, KEYSTORE_TYPE, KEYSTORE_PASSWORD, KEYSTORE_CERTIFICATE_PASSWORD, KEY_ALIAS});
    }

    KeyStoreConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String keyStoreFileName() {
        return (String)this.attributes.attribute(KEYSTORE_FILENAME).get();
    }

    public String keyStoreType() {
        return (String)this.attributes.attribute(KEYSTORE_TYPE).get();
    }

    public char[] keyStorePassword() {
        return Util.toCharArray((String)((String)this.attributes.attribute(KEYSTORE_PASSWORD).get()));
    }

    public char[] keyStoreCertificatePassword() {
        return Util.toCharArray((String)((String)this.attributes.attribute(KEYSTORE_CERTIFICATE_PASSWORD).get()));
    }

    public String keyAlias() {
        return (String)this.attributes.attribute(KEY_ALIAS).get();
    }

    public String toString() {
        return this.attributes.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyStoreConfiguration that = (KeyStoreConfiguration)o;
        return this.attributes != null ? this.attributes.equals((Object)that.attributes) : that.attributes == null;
    }

    public int hashCode() {
        return this.attributes != null ? this.attributes.hashCode() : 0;
    }
}

