/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health;

import java.util.List;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.jboss.as.controller.LocalModelControllerClient;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;

class ServerReadinessProbes {
    private static final ModelNode READ_SERVER_STATE_ATTRIBUTE = new ModelNode();
    private static final ModelNode READ_BOOT_ERRORS;
    private static final ModelNode READ_DEPLOYMENTS_STATUS;

    ServerReadinessProbes() {
    }

    static {
        READ_SERVER_STATE_ATTRIBUTE.get("operation").set("read-attribute");
        READ_SERVER_STATE_ATTRIBUTE.get("address").set(new ModelNode());
        READ_SERVER_STATE_ATTRIBUTE.get("name").set("server-state");
        READ_BOOT_ERRORS = new ModelNode();
        READ_BOOT_ERRORS.get("operation").set("read-boot-errors");
        READ_BOOT_ERRORS.get("address").add("core-service", "management");
        READ_DEPLOYMENTS_STATUS = new ModelNode();
        READ_DEPLOYMENTS_STATUS.get("operation").set("read-attribute");
        READ_DEPLOYMENTS_STATUS.get("address").add("deployment", "*");
        READ_DEPLOYMENTS_STATUS.get("name").set("status");
    }

    static class DeploymentsStatusCheck
    implements HealthCheck {
        private LocalModelControllerClient modelControllerClient;

        DeploymentsStatusCheck(LocalModelControllerClient modelControllerClient) {
            this.modelControllerClient = modelControllerClient;
        }

        public HealthCheckResponse call() {
            ModelNode responses = this.modelControllerClient.execute(READ_DEPLOYMENTS_STATUS);
            HealthCheckResponseBuilder check = HealthCheckResponse.named((String)"deployments-status");
            if (!"success".equals(responses.get("outcome").asStringOrNull())) {
                return check.down().build();
            }
            if (!responses.get("result").isDefined()) {
                return check.down().build();
            }
            boolean globalStatus = true;
            for (ModelNode response : responses.get("result").asList()) {
                String value;
                boolean deploymentUp = false;
                String data = null;
                if (!"success".equals(response.get("outcome").asStringOrNull())) {
                    data = "DMR Query failed";
                } else if (response.hasDefined("failure-description")) {
                    data = response.get("failure-description").asString();
                }
                ModelNode result = response.get("result");
                if (!result.isDefined()) {
                    data = "status undefined";
                }
                if ("OK".equals(value = result.asString())) {
                    deploymentUp = true;
                }
                if (data == null) {
                    data = value;
                }
                PathAddress address = PathAddress.pathAddress((ModelNode)response.get("address"));
                String deploymentName = address.getElement(0).getValue();
                check.withData(deploymentName, data);
                globalStatus = globalStatus && deploymentUp;
            }
            return check.state(globalStatus).build();
        }
    }

    static class NoBootErrorsCheck
    implements HealthCheck {
        private LocalModelControllerClient modelControllerClient;

        NoBootErrorsCheck(LocalModelControllerClient modelControllerClient) {
            this.modelControllerClient = modelControllerClient;
        }

        public HealthCheckResponse call() {
            ModelNode response = this.modelControllerClient.execute(READ_BOOT_ERRORS);
            HealthCheckResponseBuilder check = HealthCheckResponse.named((String)"boot-errors");
            if (!"success".equals(response.get("outcome").asStringOrNull())) {
                return check.down().build();
            }
            if (response.hasDefined("failure-description")) {
                return check.down().withData("failure-description", response.get("failure-description").asString()).build();
            }
            ModelNode result = response.get("result");
            if (!result.isDefined()) {
                return check.down().build();
            }
            List errors = result.asList();
            if (errors.isEmpty()) {
                return check.up().build();
            }
            return check.down().withData("boot-errors", result.toJSONString(true)).build();
        }
    }

    static class ServerStateCheck
    implements HealthCheck {
        private LocalModelControllerClient modelControllerClient;

        ServerStateCheck(LocalModelControllerClient modelControllerClient) {
            this.modelControllerClient = modelControllerClient;
        }

        public HealthCheckResponse call() {
            ModelNode response = this.modelControllerClient.execute(READ_SERVER_STATE_ATTRIBUTE);
            HealthCheckResponseBuilder check = HealthCheckResponse.named((String)"server-state");
            if (!"success".equals(response.get("outcome").asStringOrNull())) {
                return check.down().build();
            }
            if (response.hasDefined("failure-description")) {
                return check.down().withData("failure-description", response.get("failure-description").asString()).build();
            }
            ModelNode result = response.get("result");
            if (!result.isDefined()) {
                return check.down().build();
            }
            String value = result.asString();
            return check.state("running".equals(value)).withData("value", value).build();
        }
    }
}

