/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.simple;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.security.KeyPair;
import java.util.Objects;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.simple.SimpleClientConfigurator;
import org.apache.sshd.common.util.ValidateUtils;

public interface SimpleSessionClient
extends SimpleClientConfigurator,
Channel {
    default public ClientSession sessionLogin(String host, String username, String password) throws IOException {
        return this.sessionLogin(host, 22, username, password);
    }

    default public ClientSession sessionLogin(String host, int port, String username, String password) throws IOException {
        return this.sessionLogin(InetAddress.getByName(ValidateUtils.checkNotNullAndNotEmpty((String)host, (String)"No host")), port, username, password);
    }

    default public ClientSession sessionLogin(String host, String username, KeyPair identity) throws IOException {
        return this.sessionLogin(host, 22, username, identity);
    }

    default public ClientSession sessionLogin(String host, int port, String username, KeyPair identity) throws IOException {
        return this.sessionLogin(InetAddress.getByName(ValidateUtils.checkNotNullAndNotEmpty((String)host, (String)"No host")), port, username, identity);
    }

    default public ClientSession sessionLogin(InetAddress host, String username, String password) throws IOException {
        return this.sessionLogin(host, 22, username, password);
    }

    default public ClientSession sessionLogin(InetAddress host, int port, String username, String password) throws IOException {
        return this.sessionLogin((SocketAddress)new InetSocketAddress(Objects.requireNonNull(host, "No host address"), port), username, password);
    }

    default public ClientSession sessionLogin(InetAddress host, String username, KeyPair identity) throws IOException {
        return this.sessionLogin(host, 22, username, identity);
    }

    default public ClientSession sessionLogin(InetAddress host, int port, String username, KeyPair identity) throws IOException {
        return this.sessionLogin((SocketAddress)new InetSocketAddress(Objects.requireNonNull(host, "No host address"), port), username, identity);
    }

    public ClientSession sessionLogin(SocketAddress var1, String var2, String var3) throws IOException;

    public ClientSession sessionLogin(SocketAddress var1, String var2, KeyPair var3) throws IOException;
}

