/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ejb.EJBException;
import javax.net.ssl.SSLSession;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentIsStoppedException;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.interceptors.InvocationType;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.EJBComponentUnavailableException;
import org.jboss.as.ejb3.component.interceptors.CancellationFlag;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateless.StatelessSessionComponent;
import org.jboss.as.ejb3.deployment.DeploymentModuleIdentifier;
import org.jboss.as.ejb3.deployment.DeploymentRepository;
import org.jboss.as.ejb3.deployment.DeploymentRepositoryListener;
import org.jboss.as.ejb3.deployment.EjbDeploymentInformation;
import org.jboss.as.ejb3.deployment.ModuleDeployment;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.SecurityActions;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.ProtocolSocketBinding;
import org.jboss.as.security.remoting.RemoteConnection;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.ClusterAffinity;
import org.jboss.ejb.client.EJBIdentifier;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBMethodLocator;
import org.jboss.ejb.client.EJBModuleIdentifier;
import org.jboss.ejb.client.NodeAffinity;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.server.Association;
import org.jboss.ejb.server.CancelHandle;
import org.jboss.ejb.server.ClusterTopologyListener;
import org.jboss.ejb.server.InvocationRequest;
import org.jboss.ejb.server.ListenerHandle;
import org.jboss.ejb.server.ModuleAvailabilityListener;
import org.jboss.ejb.server.Request;
import org.jboss.ejb.server.SessionOpenRequest;
import org.jboss.invocation.InterceptorContext;
import org.jboss.remoting3.Connection;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.registry.RegistryListener;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.manager.WildFlySecurityManager;

final class AssociationImpl
implements Association,
AutoCloseable {
    private static final String RETURNED_CONTEXT_DATA_KEY = "jboss.returned.keys";
    private static final ListenerHandle NOOP_LISTENER_HANDLE = new ListenerHandle(){

        public void close() {
        }
    };
    private final DeploymentRepository deploymentRepository;
    private final Map<Integer, ClusterTopologyRegistrar> clusterTopologyRegistrars;
    private volatile Executor executor;

    AssociationImpl(DeploymentRepository deploymentRepository, List<Map.Entry<ProtocolSocketBinding, Registry<String, List<ClientMapping>>>> clientMappingRegistries) {
        this.deploymentRepository = deploymentRepository;
        this.clusterTopologyRegistrars = clientMappingRegistries.isEmpty() ? Collections.emptyMap() : new HashMap(clientMappingRegistries.size());
        for (Map.Entry<ProtocolSocketBinding, Registry<String, List<ClientMapping>>> entry : clientMappingRegistries) {
            this.clusterTopologyRegistrars.put(entry.getKey().getSocketBinding().getSocketAddress().getPort(), new ClusterTopologyRegistrar(entry.getValue()));
        }
    }

    @Override
    public void close() {
        for (ClusterTopologyRegistrar registrar : this.clusterTopologyRegistrars.values()) {
            registrar.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CancelHandle receiveInvocationRequest(final @NotNull InvocationRequest invocationRequest) {
        boolean oneWay;
        InvocationRequest.Resolved requestContent;
        String beanName;
        String distinctName;
        String moduleName;
        EJBIdentifier ejbIdentifier = invocationRequest.getEJBIdentifier();
        String appName = ejbIdentifier.getAppName();
        EjbDeploymentInformation ejbDeploymentInformation = this.findEJB(appName, moduleName = ejbIdentifier.getModuleName(), distinctName = ejbIdentifier.getDistinctName(), beanName = ejbIdentifier.getBeanName());
        if (ejbDeploymentInformation == null) {
            invocationRequest.writeNoSuchEJB();
            return CancelHandle.NULL;
        }
        ClassLoader classLoader = ejbDeploymentInformation.getDeploymentClassLoader();
        ClassLoader originalTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)classLoader);
        try {
            requestContent = invocationRequest.getRequestContent(classLoader);
        }
        catch (IOException | ClassNotFoundException e) {
            invocationRequest.writeException((Exception)((Object)new EJBException(e)));
            CancelHandle cancelHandle = CancelHandle.NULL;
            return cancelHandle;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)originalTccl);
        }
        Map attachments = requestContent.getAttachments();
        EJBLocator ejbLocator = requestContent.getEJBLocator();
        String viewClassName = ejbLocator.getViewType().getName();
        if (!ejbDeploymentInformation.isRemoteView(viewClassName)) {
            invocationRequest.writeWrongViewType();
            return CancelHandle.NULL;
        }
        ComponentView componentView = ejbDeploymentInformation.getView(viewClassName);
        Method invokedMethod = AssociationImpl.findMethod(componentView, invocationRequest.getMethodLocator());
        if (invokedMethod == null) {
            invocationRequest.writeNoSuchMethod();
            return CancelHandle.NULL;
        }
        boolean isAsync = componentView.isAsynchronous(invokedMethod);
        boolean bl = oneWay = isAsync && invokedMethod.getReturnType() == Void.TYPE;
        if (oneWay) {
            this.updateAffinities(invocationRequest, attachments, ejbLocator, componentView);
            requestContent.writeInvocationResult(null);
        } else if (isAsync) {
            invocationRequest.writeProceedAsync();
        }
        CancellationFlag cancellationFlag = new CancellationFlag();
        Runnable runnable = () -> {
            Object result;
            if (!cancellationFlag.runIfNotCancelled()) {
                if (!oneWay) {
                    invocationRequest.writeCancelResponse();
                }
                return;
            }
            Connection remotingConnection = (Connection)invocationRequest.getProviderInterface(Connection.class);
            if (remotingConnection != null) {
                SecurityActions.remotingContextSetConnection(remotingConnection);
            } else if (invocationRequest.getSecurityIdentity() != null) {
                SecurityActions.remotingContextSetConnection(new RemoteConnection(){

                    public SSLSession getSslSession() {
                        return null;
                    }

                    public SecurityIdentity getSecurityIdentity() {
                        return invocationRequest.getSecurityIdentity();
                    }
                });
            }
            try {
                HashMap<String, Object> contextDataHolder = new HashMap<String, Object>();
                result = AssociationImpl.invokeMethod(componentView, invokedMethod, invocationRequest, requestContent, cancellationFlag, contextDataHolder);
                attachments.putAll(contextDataHolder);
            }
            catch (EJBComponentUnavailableException ex) {
                EjbLogger.EJB3_INVOCATION_LOGGER.debugf("Cannot handle method invocation: %s on bean: %s due to EJB component unavailability exception. Returning a no such EJB available message back to client", invokedMethod, beanName);
                if (!oneWay) {
                    invocationRequest.writeNoSuchEJB();
                }
                return;
            }
            catch (ComponentIsStoppedException ex) {
                EjbLogger.EJB3_INVOCATION_LOGGER.debugf("Cannot handle method invocation: %s on bean: %s due to EJB component stopped exception. Returning a no such EJB available message back to client", invokedMethod, beanName);
                if (!oneWay) {
                    invocationRequest.writeNoSuchEJB();
                }
                return;
            }
            catch (CancellationException ex) {
                if (!oneWay) {
                    invocationRequest.writeCancelResponse();
                }
                return;
            }
            catch (Exception exception) {
                if (oneWay) {
                    return;
                }
                Throwable cause = exception.getCause();
                Throwable exceptionToWrite = componentView.getComponent() instanceof StatefulSessionComponent && exception instanceof EJBException && cause != null ? (!componentView.getComponent().isRemotable(cause) ? new EJBException(exception.getLocalizedMessage()) : exception) : exception;
                invocationRequest.writeException((Exception)exceptionToWrite);
                return;
            }
            finally {
                SecurityActions.remotingContextClear();
            }
            if (!oneWay) {
                try {
                    this.updateAffinities(invocationRequest, attachments, ejbLocator, componentView);
                    requestContent.writeInvocationResult(result);
                }
                catch (Throwable ioe) {
                    EjbLogger.REMOTE_LOGGER.couldNotWriteMethodInvocation(ioe, invokedMethod, beanName, appName, moduleName, distinctName);
                }
            }
        };
        this.execute((Request)invocationRequest, runnable, isAsync, false);
        return cancellationFlag::cancel;
    }

    private void updateAffinities(InvocationRequest invocationRequest, Map<String, Object> attachments, EJBLocator<?> ejbLocator, ComponentView componentView) {
        Affinity legacyAffinity = null;
        Affinity weakAffinity = null;
        Affinity strongAffinity = null;
        if (ejbLocator.isStateful() && componentView.getComponent() instanceof StatefulSessionComponent) {
            StatefulSessionComponent statefulSessionComponent = (StatefulSessionComponent)componentView.getComponent();
            strongAffinity = AssociationImpl.getStrongAffinity(statefulSessionComponent);
            weakAffinity = legacyAffinity = AssociationImpl.getWeakAffinity(statefulSessionComponent, ejbLocator.asStateful());
        } else if (componentView.getComponent() instanceof StatelessSessionComponent) {
            strongAffinity = legacyAffinity = this.getStatelessAffinity((Request)invocationRequest);
        }
        if (strongAffinity != null && !(strongAffinity instanceof NodeAffinity)) {
            invocationRequest.updateStrongAffinity(strongAffinity);
        }
        if (weakAffinity != null && !weakAffinity.equals(Affinity.NONE)) {
            invocationRequest.updateWeakAffinity(weakAffinity);
        }
        if (legacyAffinity != null && !legacyAffinity.equals(Affinity.NONE)) {
            attachments.put("jboss.ejb.weak.affinity", legacyAffinity);
        }
        EjbLogger.EJB3_INVOCATION_LOGGER.debugf("Called receiveInvocationRequest ( bean = %s ): strong affinity = %s, weak affinity = %s \n", componentView.getComponent().getClass().getName(), strongAffinity, weakAffinity);
    }

    private void execute(Request request, Runnable task, boolean isAsync, boolean alwaysDispatch) {
        if (request.getProtocol().equals("local") && !isAsync) {
            task.run();
        } else if (this.executor != null) {
            this.executor.execute(task);
        } else if (isAsync || alwaysDispatch) {
            request.getRequestExecutor().execute(task);
        } else {
            task.run();
        }
    }

    @NotNull
    public CancelHandle receiveSessionOpenRequest(@NotNull SessionOpenRequest sessionOpenRequest) {
        EJBIdentifier ejbIdentifier = sessionOpenRequest.getEJBIdentifier();
        String appName = ejbIdentifier.getAppName();
        String moduleName = ejbIdentifier.getModuleName();
        String beanName = ejbIdentifier.getBeanName();
        String distinctName = ejbIdentifier.getDistinctName();
        EjbDeploymentInformation ejbDeploymentInformation = this.findEJB(appName, moduleName, distinctName, beanName);
        if (ejbDeploymentInformation == null) {
            sessionOpenRequest.writeNoSuchEJB();
            return CancelHandle.NULL;
        }
        EJBComponent component = ejbDeploymentInformation.getEjbComponent();
        component.waitForComponentStart();
        if (!(component instanceof StatefulSessionComponent)) {
            sessionOpenRequest.writeNotStateful();
            return CancelHandle.NULL;
        }
        StatefulSessionComponent statefulSessionComponent = (StatefulSessionComponent)component;
        AtomicBoolean cancelled = new AtomicBoolean();
        Runnable runnable = () -> {
            Affinity weakAffinity;
            SessionID sessionID;
            if (cancelled.get()) {
                sessionOpenRequest.writeCancelResponse();
                return;
            }
            try {
                sessionID = statefulSessionComponent.createSessionRemote();
            }
            catch (EJBComponentUnavailableException ex) {
                EjbLogger.EJB3_INVOCATION_LOGGER.debugf("Cannot handle session creation on bean: %s due to EJB component unavailability exception. Returning a no such EJB available message back to client", beanName);
                sessionOpenRequest.writeNoSuchEJB();
                return;
            }
            catch (ComponentIsStoppedException ex) {
                EjbLogger.EJB3_INVOCATION_LOGGER.debugf("Cannot handle session creation on bean: %s due to EJB component stopped exception. Returning a no such EJB available message back to client", beanName);
                sessionOpenRequest.writeNoSuchEJB();
                return;
            }
            catch (Exception t) {
                EjbLogger.REMOTE_LOGGER.exceptionGeneratingSessionId(t, statefulSessionComponent.getComponentName(), ejbIdentifier);
                sessionOpenRequest.writeException(t);
                return;
            }
            Affinity strongAffinity = AssociationImpl.getStrongAffinity(statefulSessionComponent);
            if (strongAffinity != null && !(strongAffinity instanceof NodeAffinity)) {
                sessionOpenRequest.updateStrongAffinity(strongAffinity);
            }
            if ((weakAffinity = AssociationImpl.getWeakAffinity(statefulSessionComponent, sessionID)) != null && !Affinity.NONE.equals(weakAffinity)) {
                sessionOpenRequest.updateWeakAffinity(weakAffinity);
            }
            EjbLogger.EJB3_INVOCATION_LOGGER.debugf("Called receiveSessionOpenRequest ( bean = %s ): strong affinity = %s, weak affinity = %s \n", statefulSessionComponent.getClass().getName(), strongAffinity, weakAffinity);
            sessionOpenRequest.convertToStateful(sessionID);
        };
        this.execute((Request)sessionOpenRequest, runnable, false, true);
        return ignored -> cancelled.set(true);
    }

    public ListenerHandle registerClusterTopologyListener(@NotNull ClusterTopologyListener listener) {
        ClusterTopologyRegistrar registrar = this.findClusterTopologyRegistrar(listener.getConnection().getLocalAddress());
        return registrar != null ? registrar.registerClusterTopologyListener(listener) : NOOP_LISTENER_HANDLE;
    }

    public ListenerHandle registerModuleAvailabilityListener(final @NotNull ModuleAvailabilityListener moduleAvailabilityListener) {
        DeploymentRepositoryListener listener = new DeploymentRepositoryListener(){

            @Override
            public void listenerAdded(DeploymentRepository repository) {
                ArrayList<EJBModuleIdentifier> list = new ArrayList<EJBModuleIdentifier>();
                if (!this.repositoryIsSuspended()) {
                    for (DeploymentModuleIdentifier deploymentModuleIdentifier : repository.getModules().keySet()) {
                        EJBModuleIdentifier ejbModuleIdentifier = AssociationImpl.toModuleIdentifier(deploymentModuleIdentifier);
                        list.add(ejbModuleIdentifier);
                    }
                    EjbLogger.EJB3_INVOCATION_LOGGER.debugf("Sending initial module availability to connecting client: server is not suspended", new Object[0]);
                } else {
                    EjbLogger.EJB3_INVOCATION_LOGGER.debugf("Sending empty initial module availability to connecting client: server is suspended", new Object[0]);
                }
                moduleAvailabilityListener.moduleAvailable(list);
            }

            @Override
            public void deploymentAvailable(DeploymentModuleIdentifier deployment, ModuleDeployment moduleDeployment) {
            }

            @Override
            public void deploymentStarted(DeploymentModuleIdentifier deployment, ModuleDeployment moduleDeployment) {
                moduleAvailabilityListener.moduleAvailable(Collections.singletonList(AssociationImpl.toModuleIdentifier(deployment)));
            }

            @Override
            public void deploymentRemoved(DeploymentModuleIdentifier deployment) {
                moduleAvailabilityListener.moduleUnavailable(Collections.singletonList(AssociationImpl.toModuleIdentifier(deployment)));
            }

            @Override
            public void deploymentSuspended(DeploymentModuleIdentifier deployment) {
                moduleAvailabilityListener.moduleUnavailable(Collections.singletonList(AssociationImpl.toModuleIdentifier(deployment)));
            }

            @Override
            public void deploymentResumed(DeploymentModuleIdentifier deployment) {
                moduleAvailabilityListener.moduleAvailable(Collections.singletonList(AssociationImpl.toModuleIdentifier(deployment)));
            }

            private boolean repositoryIsSuspended() {
                return AssociationImpl.this.deploymentRepository.isSuspended();
            }
        };
        this.deploymentRepository.addListener(listener);
        return () -> this.deploymentRepository.removeListener(listener);
    }

    static EJBModuleIdentifier toModuleIdentifier(DeploymentModuleIdentifier identifier) {
        return new EJBModuleIdentifier(identifier.getApplicationName(), identifier.getModuleName(), identifier.getDistinctName());
    }

    private EjbDeploymentInformation findEJB(String appName, String moduleName, String distinctName, String beanName) {
        DeploymentModuleIdentifier ejbModule = new DeploymentModuleIdentifier(appName, moduleName, distinctName);
        Map<DeploymentModuleIdentifier, ModuleDeployment> modules = this.deploymentRepository.getStartedModules();
        if (modules == null || modules.isEmpty()) {
            return null;
        }
        ModuleDeployment moduleDeployment = modules.get(ejbModule);
        if (moduleDeployment == null) {
            return null;
        }
        return moduleDeployment.getEjbs().get(beanName);
    }

    static Object invokeMethod(ComponentView componentView, Method method, InvocationRequest incomingInvocation, InvocationRequest.Resolved content, CancellationFlag cancellationFlag, Map<String, Object> contextDataHolder) throws Exception {
        Object result;
        EJBLocator ejbLocator;
        InterceptorContext interceptorContext = new InterceptorContext();
        interceptorContext.setParameters(content.getParameters());
        interceptorContext.setMethod(method);
        interceptorContext.putPrivateData(Component.class, (Object)componentView.getComponent());
        interceptorContext.putPrivateData(ComponentView.class, (Object)componentView);
        interceptorContext.putPrivateData(InvocationType.class, (Object)InvocationType.REMOTE);
        interceptorContext.setBlockingCaller(false);
        HashMap invocationContextData = new HashMap();
        interceptorContext.setContextData(invocationContextData);
        if (content.getAttachments() != null) {
            for (Map.Entry attachment : content.getAttachments().entrySet()) {
                if (attachment == null) continue;
                String key = (String)attachment.getKey();
                Object value = attachment.getValue();
                if ("org.jboss.ejb.client.invocation.attachments".equals(key)) {
                    Map privateAttachments = (Map)value;
                    for (Map.Entry privateAttachment : privateAttachments.entrySet()) {
                        interceptorContext.putPrivateData(privateAttachment.getKey(), privateAttachment.getValue());
                    }
                    continue;
                }
                invocationContextData.put(key, value);
            }
        }
        if ((ejbLocator = content.getEJBLocator()).isStateful()) {
            interceptorContext.putPrivateData(SessionID.class, (Object)ejbLocator.asStateful().getSessionId());
        }
        if (content.hasTransaction()) {
            interceptorContext.setTransactionSupplier(() -> ((InvocationRequest.Resolved)content).getTransaction());
        }
        SecurityIdentity securityIdentity = incomingInvocation.getSecurityIdentity();
        boolean isAsync = componentView.isAsynchronous(method);
        boolean oneWay = isAsync && method.getReturnType() == Void.TYPE;
        boolean isSessionBean = componentView.getComponent() instanceof SessionBeanComponent;
        if (isAsync && isSessionBean) {
            if (!oneWay) {
                interceptorContext.putPrivateData(CancellationFlag.class, (Object)cancellationFlag);
            }
            result = AssociationImpl.invokeWithIdentity(componentView, interceptorContext, securityIdentity);
            AssociationImpl.handleReturningContextData(contextDataHolder, interceptorContext, content);
            return result == null ? null : ((Future)result).get();
        }
        result = AssociationImpl.invokeWithIdentity(componentView, interceptorContext, securityIdentity);
        AssociationImpl.handleReturningContextData(contextDataHolder, interceptorContext, content);
        return result;
    }

    private static void handleReturningContextData(Map<String, Object> contextDataHolder, InterceptorContext interceptorContext, InvocationRequest.Resolved content) {
        Set returnKeys = (Set)content.getAttachments().get(RETURNED_CONTEXT_DATA_KEY);
        if (returnKeys == null) {
            return;
        }
        for (String key : returnKeys) {
            if (!interceptorContext.getContextData().containsKey(key)) continue;
            contextDataHolder.put(key, interceptorContext.getContextData().get(key));
        }
    }

    private static Object invokeWithIdentity(ComponentView componentView, InterceptorContext interceptorContext, SecurityIdentity securityIdentity) throws Exception {
        return securityIdentity == null ? componentView.invoke(interceptorContext) : securityIdentity.runAsFunctionEx(ComponentView::invoke, (Object)componentView, (Object)interceptorContext);
    }

    private static Method findMethod(ComponentView componentView, EJBMethodLocator ejbMethodLocator) {
        Set viewMethods = componentView.getViewMethods();
        for (Method method : viewMethods) {
            Class<?>[] methodParamTypes;
            if (!method.getName().equals(ejbMethodLocator.getMethodName()) || (methodParamTypes = method.getParameterTypes()).length != ejbMethodLocator.getParameterCount()) continue;
            boolean found = true;
            for (int i = 0; i < methodParamTypes.length; ++i) {
                if (methodParamTypes[i].getName().equals(ejbMethodLocator.getParameterTypeName(i))) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return method;
        }
        return null;
    }

    private static Affinity getStrongAffinity(StatefulSessionComponent statefulSessionComponent) {
        return statefulSessionComponent.getCache().getStrictAffinity();
    }

    private static Affinity getWeakAffinity(StatefulSessionComponent statefulSessionComponent, StatefulEJBLocator<?> statefulEJBLocator) {
        SessionID sessionID = statefulEJBLocator.getSessionId();
        return AssociationImpl.getWeakAffinity(statefulSessionComponent, sessionID);
    }

    private static Affinity getWeakAffinity(StatefulSessionComponent statefulSessionComponent, SessionID sessionID) {
        return statefulSessionComponent.getCache().getWeakAffinity(sessionID);
    }

    private Affinity getStatelessAffinity(Request request) {
        ClusterTopologyRegistrar registrar = this.findClusterTopologyRegistrar(request.getLocalAddress());
        Group group = registrar != null ? registrar.getGroup() : null;
        return group != null && !group.isSingleton() ? new ClusterAffinity(group.getName()) : null;
    }

    private ClusterTopologyRegistrar findClusterTopologyRegistrar(SocketAddress localAddress) {
        return localAddress instanceof InetSocketAddress ? this.clusterTopologyRegistrars.get(((InetSocketAddress)localAddress).getPort()) : null;
    }

    Executor getExecutor() {
        return this.executor;
    }

    void setExecutor(Executor executor) {
        this.executor = executor;
    }

    void sendTopologyUpdateIfLastNodeToLeave() {
        for (ClusterTopologyRegistrar registrar : this.clusterTopologyRegistrars.values()) {
            registrar.sendTopologyUpdateIfLastNodeToLeave();
        }
    }

    private class ClusterTopologyRegistrar
    implements RegistryListener<String, List<ClientMapping>> {
        private final Set<ClusterTopologyListener> clusterTopologyListeners = ConcurrentHashMap.newKeySet();
        private final Registry<String, List<ClientMapping>> clientMappingRegistry;
        private final Registration listenerRegistration;

        ClusterTopologyRegistrar(Registry<String, List<ClientMapping>> clientMappingRegistry) {
            this.clientMappingRegistry = clientMappingRegistry;
            this.listenerRegistration = clientMappingRegistry.register((Object)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addedEntries(Map<String, List<ClientMapping>> added) {
            ClusterTopologyListener.ClusterInfo info = this.getClusterInfo(added);
            Iterator<ClusterTopologyListener> iterator = this.clusterTopologyListeners.iterator();
            while (iterator.hasNext()) {
                ClusterTopologyListener listener;
                ClusterTopologyListener clusterTopologyListener = listener = iterator.next();
                synchronized (clusterTopologyListener) {
                    listener.clusterNewNodesAdded(info);
                }
            }
        }

        public void updatedEntries(Map<String, List<ClientMapping>> updated) {
            this.addedEntries(updated);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedEntries(Map<String, List<ClientMapping>> removed) {
            List<ClusterTopologyListener.ClusterRemovalInfo> removals = Collections.singletonList(new ClusterTopologyListener.ClusterRemovalInfo(this.clientMappingRegistry.getGroup().getName(), new ArrayList<String>(removed.keySet())));
            Iterator<ClusterTopologyListener> iterator = this.clusterTopologyListeners.iterator();
            while (iterator.hasNext()) {
                ClusterTopologyListener listener;
                ClusterTopologyListener clusterTopologyListener = listener = iterator.next();
                synchronized (clusterTopologyListener) {
                    listener.clusterNodesRemoved(removals);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ListenerHandle registerClusterTopologyListener(ClusterTopologyListener listener) {
            ClusterTopologyListener clusterTopologyListener = listener;
            synchronized (clusterTopologyListener) {
                this.clusterTopologyListeners.add(listener);
                listener.clusterTopology(!this.clientMappingRegistry.getGroup().isSingleton() ? Collections.singletonList(this.getClusterInfo(this.clientMappingRegistry.getEntries())) : Collections.emptyList());
            }
            return () -> this.clusterTopologyListeners.remove(listener);
        }

        void close() {
            this.listenerRegistration.close();
            this.clusterTopologyListeners.clear();
        }

        Group getGroup() {
            return this.clientMappingRegistry.getGroup();
        }

        ClusterTopologyListener.ClusterInfo getClusterInfo(Map<String, List<ClientMapping>> entries) {
            ArrayList<ClusterTopologyListener.NodeInfo> nodeInfoList = new ArrayList<ClusterTopologyListener.NodeInfo>(entries.size());
            for (Map.Entry<String, List<ClientMapping>> entry : entries.entrySet()) {
                String nodeName = entry.getKey();
                List<ClientMapping> clientMappingList = entry.getValue();
                ArrayList<ClusterTopologyListener.MappingInfo> mappingInfoList = new ArrayList<ClusterTopologyListener.MappingInfo>(clientMappingList.size());
                for (ClientMapping clientMapping : clientMappingList) {
                    try {
                        if (InetAddress.getByName(clientMapping.getDestinationAddress()).isAnyLocalAddress()) {
                            EjbLogger.REMOTE_LOGGER.clusteredEJBsBoundToINADDRANY(nodeName, clientMapping.getDestinationAddress());
                        }
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                    mappingInfoList.add(new ClusterTopologyListener.MappingInfo(clientMapping.getDestinationAddress(), clientMapping.getDestinationPort(), clientMapping.getSourceNetworkAddress(), clientMapping.getSourceNetworkMaskBits()));
                }
                nodeInfoList.add(new ClusterTopologyListener.NodeInfo(nodeName, mappingInfoList));
            }
            return new ClusterTopologyListener.ClusterInfo(this.clientMappingRegistry.getGroup().getName(), nodeInfoList);
        }

        void sendTopologyUpdateIfLastNodeToLeave() {
            boolean loneMember;
            Map.Entry localEntry = this.clientMappingRegistry.getEntry(this.clientMappingRegistry.getGroup().getLocalMember());
            Map entries = this.clientMappingRegistry.getEntries();
            boolean bl = localEntry != null ? entries.size() == 1 && entries.containsKey(localEntry.getKey()) : (loneMember = entries.isEmpty());
            if (loneMember) {
                String cluster = this.clientMappingRegistry.getGroup().getName();
                for (ClusterTopologyListener listener : this.clusterTopologyListeners) {
                    listener.clusterRemoval(Arrays.asList(cluster));
                }
            }
        }
    }
}

