/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins.javaee;

import java.lang.reflect.Method;
import java.security.CodeSource;
import java.security.Principal;
import java.util.HashMap;
import java.util.Set;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.RunAs;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.resources.EJBResource;
import org.jboss.security.callbacks.SecurityContextCallbackHandler;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.javaee.AbstractEJBAuthorizationHelper;
import org.jboss.security.javaee.SecurityRoleRef;
import org.jboss.security.javaee.exceptions.MissingArgumentsException;
import org.jboss.security.javaee.exceptions.WrongEEResourceException;
import org.jboss.security.plugins.javaee.SecurityActions;

public class EJBAuthorizationHelper
extends AbstractEJBAuthorizationHelper {
    protected String POLICY_REGISTRATION_JNDI = "java:/policyRegistration";

    @Override
    public boolean authorize(String ejbName, Method ejbMethod, Principal ejbPrincipal, String invocationInterfaceString, CodeSource ejbCodeSource, Subject callerSubject, RunAs callerRunAs, String contextID, RoleGroup methodRoles) {
        if (ejbName == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("ejbName");
        }
        if (ejbMethod == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("ejbMethod");
        }
        if (ejbCodeSource == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("ejbCodeSource");
        }
        if (contextID == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("contextID");
        }
        if (callerSubject == null && callerRunAs == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("callerSubject");
        }
        AuthorizationManager am = this.securityContext.getAuthorizationManager();
        if (am == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullProperty("AuthorizationManager");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (this.policyRegistration == null) {
                this.policyRegistration = this.getPolicyRegistrationFromJNDI();
            }
        }
        catch (Exception e) {
            PicketBoxLogger.LOGGER.debugIgnoredException(e);
        }
        map.put("policyRegistration", this.policyRegistration);
        EJBResource ejbResource = new EJBResource(map);
        ejbResource.setEjbVersion(this.version);
        ejbResource.setPolicyContextID(contextID);
        ejbResource.setCallerRunAsIdentity(callerRunAs);
        ejbResource.setEjbName(ejbName);
        ejbResource.setEjbMethod(ejbMethod);
        ejbResource.setPrincipal(ejbPrincipal);
        ejbResource.setEjbMethodInterface(invocationInterfaceString);
        ejbResource.setCodeSource(ejbCodeSource);
        ejbResource.setCallerRunAsIdentity(callerRunAs);
        ejbResource.setCallerSubject(callerSubject);
        ejbResource.setEjbMethodRoles(methodRoles);
        SecurityContextCallbackHandler sch = new SecurityContextCallbackHandler(this.securityContext);
        RoleGroup callerRoles = am.getSubjectRoles(callerSubject, sch);
        boolean isAuthorized = false;
        try {
            int check = am.authorize((Resource)ejbResource, callerSubject, callerRoles);
            isAuthorized = check == 1;
            this.authorizationAudit(isAuthorized ? "Success" : "Failure", ejbResource, null);
        }
        catch (Exception e) {
            isAuthorized = false;
            PicketBoxLogger.LOGGER.debugAuthorizationError(e);
            this.authorizationAudit("Error", ejbResource, e);
        }
        return isAuthorized;
    }

    @Override
    public boolean isCallerInRole(String roleName, String ejbName, Principal ejbPrincipal, Subject callerSubject, String contextID, Set<SecurityRoleRef> securityRoleRefs) {
        return this.isCallerInRole(roleName, ejbName, ejbPrincipal, callerSubject, contextID, securityRoleRefs, false);
    }

    @Override
    public boolean isCallerInRole(Resource resource, String roleName) throws WrongEEResourceException, MissingArgumentsException {
        boolean isAuthorized = false;
        EJBResource ejbResource = (EJBResource)resource;
        if (roleName == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("roleName");
        }
        if (ejbResource.getEjbName() == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("ejbName");
        }
        if (ejbResource.getPolicyContextID() == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("contextID");
        }
        AuthorizationManager am = this.securityContext.getAuthorizationManager();
        Subject callerSubject = ejbResource.getCallerSubject();
        if (am == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullProperty("AuthorizationManager");
        }
        try {
            if (this.policyRegistration == null) {
                this.policyRegistration = this.getPolicyRegistrationFromJNDI();
            }
        }
        catch (Exception e) {
            PicketBoxLogger.LOGGER.debugIgnoredException(e);
        }
        ejbResource.add("policyRegistration", this.policyRegistration);
        ejbResource.add("roleName", roleName);
        ejbResource.add("roleRefPermissionCheck", Boolean.TRUE);
        SecurityContextCallbackHandler sch = new SecurityContextCallbackHandler(this.securityContext);
        RoleGroup callerRoles = am.getSubjectRoles(callerSubject, sch);
        try {
            int check = am.authorize((Resource)ejbResource, callerSubject, callerRoles);
            isAuthorized = check == 1;
        }
        catch (Exception e) {
            isAuthorized = false;
            if (PicketBoxLogger.LOGGER.isTraceEnabled()) {
                PicketBoxLogger.LOGGER.traceFailureExecutingMethod("isCallerInRole", e);
            } else {
                PicketBoxLogger.LOGGER.debugFailureExecutingMethod("isCallerInRole");
            }
            this.authorizationAudit("Error", ejbResource, e);
        }
        return isAuthorized;
    }

    @Override
    public boolean isCallerInRole(String roleName, String ejbName, Principal ejbPrincipal, Subject callerSubject, String contextID, Set<SecurityRoleRef> securityRoleRefs, boolean enforceEJBRestrictions) {
        if (roleName == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("roleName");
        }
        if (ejbName == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("ejbName");
        }
        if (contextID == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("contextID");
        }
        boolean isAuthorized = false;
        AuthorizationManager am = this.securityContext.getAuthorizationManager();
        if (am == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullProperty("AuthorizationManager");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (this.policyRegistration == null) {
                this.policyRegistration = this.getPolicyRegistrationFromJNDI();
            }
        }
        catch (Exception e) {
            PicketBoxLogger.LOGGER.debugIgnoredException(e);
        }
        map.put("policyRegistration", this.policyRegistration);
        map.put("roleName", roleName);
        map.put("roleRefPermissionCheck", Boolean.TRUE);
        EJBResource ejbResource = new EJBResource(map);
        ejbResource.setPolicyContextID(contextID);
        RunAs callerRunAs = SecurityActions.getIncomingRunAs(this.securityContext);
        ejbResource.setEjbVersion(this.version);
        ejbResource.setEjbName(ejbName);
        ejbResource.setPrincipal(ejbPrincipal);
        ejbResource.setCallerRunAsIdentity(callerRunAs);
        ejbResource.setSecurityRoleReferences(securityRoleRefs);
        ejbResource.setEnforceEJBRestrictions(enforceEJBRestrictions);
        ejbResource.setCallerSubject(callerSubject);
        SecurityContextCallbackHandler sch = new SecurityContextCallbackHandler(this.securityContext);
        RoleGroup callerRoles = am.getSubjectRoles(callerSubject, sch);
        try {
            int check = am.authorize((Resource)ejbResource, callerSubject, callerRoles);
            isAuthorized = check == 1;
        }
        catch (Exception e) {
            isAuthorized = false;
            if (PicketBoxLogger.LOGGER.isTraceEnabled()) {
                PicketBoxLogger.LOGGER.traceFailureExecutingMethod("isCallerInRole", e);
            } else {
                PicketBoxLogger.LOGGER.debugFailureExecutingMethod("isCallerInRole");
            }
            this.authorizationAudit("Error", ejbResource, e);
        }
        return isAuthorized;
    }

    @Override
    public String getEJBVersion() {
        return this.version;
    }

    @Override
    public void setEJBVersion(String ejbVersion) {
        if (!("1.1".equalsIgnoreCase(ejbVersion) || "2.0".equalsIgnoreCase(ejbVersion) || "3.0".equalsIgnoreCase(ejbVersion))) {
            throw PicketBoxMessages.MESSAGES.invalidEJBVersion(ejbVersion);
        }
        this.version = ejbVersion;
    }

    @Override
    public boolean authorize(Resource resource) throws WrongEEResourceException, MissingArgumentsException {
        if (!(resource instanceof EJBResource)) {
            throw PicketBoxMessages.MESSAGES.invalidType(EJBResource.class.getName());
        }
        EJBResource ejbResource = (EJBResource)resource;
        this.validateEJBResource(ejbResource);
        AuthorizationManager am = this.securityContext.getAuthorizationManager();
        if (am == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullProperty("AuthorizationManager");
        }
        try {
            if (this.policyRegistration == null) {
                this.policyRegistration = this.getPolicyRegistrationFromJNDI();
            }
        }
        catch (Exception e) {
            PicketBoxLogger.LOGGER.debugIgnoredException(e);
        }
        Subject callerSubject = ejbResource.getCallerSubject();
        ejbResource.add("policyRegistration", this.policyRegistration);
        SecurityContextCallbackHandler sch = new SecurityContextCallbackHandler(this.securityContext);
        RoleGroup callerRoles = am.getSubjectRoles(callerSubject, sch);
        boolean isAuthorized = false;
        try {
            int check = am.authorize((Resource)ejbResource, callerSubject, callerRoles);
            isAuthorized = check == 1;
            this.authorizationAudit(isAuthorized ? "Success" : "Failure", ejbResource, null);
        }
        catch (Exception e) {
            isAuthorized = false;
            PicketBoxLogger.LOGGER.debugAuthorizationError(e);
            this.authorizationAudit("Error", ejbResource, e);
        }
        return isAuthorized;
    }

    private void validateEJBResource(EJBResource ejbResource) throws MissingArgumentsException {
        if (ejbResource.getEjbName() == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("ejbName");
        }
        if (ejbResource.getEjbMethod() == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("ejbMethod");
        }
        if (ejbResource.getCodeSource() == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("ejbCodeSource");
        }
        if (ejbResource.getPolicyContextID() == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("contextID");
        }
        if (ejbResource.getCallerSubject() == null && ejbResource.getCallerRunAsIdentity() == null) {
            throw new MissingArgumentsException(PicketBoxMessages.MESSAGES.missingCallerInfoMessage());
        }
    }

    private PolicyRegistration getPolicyRegistrationFromJNDI() throws Exception {
        return (PolicyRegistration)new InitialContext().lookup(this.POLICY_REGISTRATION_JNDI);
    }
}

