/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.AssociationService;
import org.jboss.as.ejb3.remote.EJBRemoteConnectorService;
import org.jboss.as.ejb3.remote.EJBRemotingConnectorClientMappingsEntryProviderService;
import org.jboss.as.ejb3.subsystem.EJB3RemoteResourceDefinition;
import org.jboss.as.ejb3.subsystem.FilterSpecClassResolverFilter;
import org.jboss.as.ejb3.subsystem.RemoteConnectorChannelCreationOptionResource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.RemotingOptions;
import org.wildfly.clustering.ejb.ClientMappingsRegistryProvider;
import org.wildfly.clustering.service.FunctionSupplierDependency;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.transaction.client.provider.remoting.RemotingTransactionService;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;

public class EJB3RemoteServiceAdd
extends AbstractBoottimeAddStepHandler {
    private final ClientMappingsRegistryProvider provider;

    EJB3RemoteServiceAdd(AttributeDefinition ... attributes) {
        super(attributes);
        Iterator<ClientMappingsRegistryProvider> providers = ServiceLoader.load(ClientMappingsRegistryProvider.class, ClientMappingsRegistryProvider.class.getClassLoader()).iterator();
        this.provider = providers.hasNext() ? providers.next() : null;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        if (operation.hasDefined(EJB3RemoteResourceDefinition.CONNECTOR_REF.getName())) {
            ModelNode connectorRef = operation.remove(EJB3RemoteResourceDefinition.CONNECTOR_REF.getName());
            operation.get(EJB3RemoteResourceDefinition.CONNECTORS.getName()).set(new ModelNode().add(connectorRef));
        }
        super.populateModel(operation, model);
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        this.installRuntimeServices(context, model);
    }

    void installRuntimeServices(OperationContext context, ModelNode model) throws OperationFailedException {
        String clientMappingsClusterName = EJB3RemoteResourceDefinition.CLIENT_MAPPINGS_CLUSTER_NAME.resolveModelAttribute(context, model).asString();
        List connectorNameNodes = EJB3RemoteResourceDefinition.CONNECTORS.resolveModelAttribute(context, model).asList();
        String threadPoolName = EJB3RemoteResourceDefinition.THREAD_POOL_NAME.resolveModelAttribute(context, model).asString();
        boolean executeInWorker = EJB3RemoteResourceDefinition.EXECUTE_IN_WORKER.resolveModelAttribute(context, model).asBoolean();
        ServiceTarget target = context.getServiceTarget();
        for (ModelNode connectorNameNode : connectorNameNodes) {
            String connectorName = connectorNameNode.asString();
            ServiceConfigurator clientMappingsEntryProviderConfigurator = new EJBRemotingConnectorClientMappingsEntryProviderService(clientMappingsClusterName, connectorName).configure(context);
            clientMappingsEntryProviderConfigurator.build(target).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
            if (this.provider == null) continue;
            ServiceSupplierDependency registryEntryDependency = new ServiceSupplierDependency(clientMappingsEntryProviderConfigurator.getServiceName());
            for (CapabilityServiceConfigurator configurator : this.provider.getServiceConfigurators(clientMappingsClusterName, connectorName, (SupplierDependency)new FunctionSupplierDependency((SupplierDependency)registryEntryDependency, Map.Entry::getValue))) {
                configurator.configure(context).build(target).install();
            }
        }
        OptionMap channelCreationOptions = this.getChannelCreationOptions(context);
        EJBRemoteConnectorService ejbRemoteConnectorService = new EJBRemoteConnectorService(channelCreationOptions, FilterSpecClassResolverFilter.getFilterForOperationContext(context));
        CapabilityServiceBuilder builder = context.getCapabilityServiceTarget().addCapability(EJB3RemoteResourceDefinition.EJB_REMOTE_CAPABILITY).setInstance((Service)ejbRemoteConnectorService).addCapabilityRequirement("org.wildfly.remoting.endpoint", Endpoint.class, ejbRemoteConnectorService.getEndpointInjector());
        if (!executeInWorker) {
            builder.addCapabilityRequirement("org.wildfly.threads.executor.ejb3", ExecutorService.class, ejbRemoteConnectorService.getExecutorService(), new String[]{threadPoolName});
        }
        builder.addDependency(AssociationService.SERVICE_NAME, AssociationService.class, ejbRemoteConnectorService.getAssociationServiceInjector()).addCapabilityRequirement("org.wildfly.transactions.remote-transaction-service", RemotingTransactionService.class, ejbRemoteConnectorService.getRemotingTransactionServiceInjector()).addAliases(new ServiceName[]{EJBRemoteConnectorService.SERVICE_NAME}).setInitialMode(ServiceController.Mode.LAZY).install();
    }

    private OptionMap getChannelCreationOptions(OperationContext context) throws OperationFailedException {
        ModelNode fullModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        ModelNode channelCreationOptions = fullModel.get("channel-creation-options");
        if (channelCreationOptions.isDefined() && channelCreationOptions.asInt() > 0) {
            ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
            OptionMap.Builder builder = OptionMap.builder();
            for (Property optionProperty : channelCreationOptions.asPropertyList()) {
                String name = optionProperty.getName();
                ModelNode propValueModel = optionProperty.getValue();
                String type = RemoteConnectorChannelCreationOptionResource.CHANNEL_CREATION_OPTION_TYPE.resolveModelAttribute(context, propValueModel).asString();
                String optionClassName = EJB3RemoteServiceAdd.getClassNameForChannelOptionType(type);
                String fullyQualifiedOptionName = optionClassName + "." + name;
                Option option = Option.fromString((String)fullyQualifiedOptionName, (ClassLoader)loader);
                String value = RemoteConnectorChannelCreationOptionResource.CHANNEL_CREATION_OPTION_VALUE.resolveModelAttribute(context, propValueModel).asString();
                builder.set(option, option.parseValue(value, loader));
            }
            return builder.getMap();
        }
        return OptionMap.EMPTY;
    }

    private static String getClassNameForChannelOptionType(String optionType) {
        if ("remoting".equals(optionType)) {
            return RemotingOptions.class.getName();
        }
        if ("xnio".equals(optionType)) {
            return Options.class.getName();
        }
        throw EjbLogger.ROOT_LOGGER.unknownChannelCreationOptionType(optionType);
    }
}

