/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.common.properties.query;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.picketlink.common.properties.FieldProperty;
import org.picketlink.common.properties.MethodProperty;
import org.picketlink.common.properties.Properties;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.PropertyAdapter;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.SecurityActions;

public class PropertyQuery<V> {
    private final Class<?> targetClass;
    private final List<PropertyCriteria> criteria;

    PropertyQuery(Class<?> targetClass) {
        if (targetClass == null) {
            throw new IllegalArgumentException("targetClass parameter may not be null");
        }
        this.targetClass = targetClass;
        this.criteria = new ArrayList<PropertyCriteria>();
    }

    public PropertyQuery<V> addCriteria(PropertyCriteria criteria) {
        this.criteria.add(criteria);
        return this;
    }

    public Property<V> getFirstResult() {
        List<Property<V>> results = this.getResultList();
        return results.isEmpty() ? null : results.get(0);
    }

    public Property<V> getFirstWritableResult() {
        List<Property<V>> results = this.getWritableResultList();
        return results.isEmpty() ? null : results.get(0);
    }

    public Property<V> getSingleResult() {
        List<Property<V>> results = this.getResultList();
        if (results.size() == 1) {
            return results.get(0);
        }
        if (results.isEmpty()) {
            throw new RuntimeException("Expected one property match, but the criteria did not match any properties on " + this.targetClass.getName());
        }
        throw new RuntimeException("Expected one property match, but the criteria matched " + results.size() + " properties on " + this.targetClass.getName());
    }

    public Property<V> getWritableSingleResult() {
        List<Property<V>> results = this.getWritableResultList();
        if (results.size() == 1) {
            return results.get(0);
        }
        if (results.isEmpty()) {
            throw new RuntimeException("Expected one property match, but the criteria did not match any properties on " + this.targetClass.getName());
        }
        throw new RuntimeException("Expected one property match, but the criteria matched " + results.size() + " properties on " + this.targetClass.getName());
    }

    public List<Property<V>> getResultList() {
        return this.getResultList(false);
    }

    public List<Property<V>> getWritableResultList() {
        return this.getResultList(true);
    }

    private List<Property<V>> getResultList(boolean writable) {
        HashMap adapters = new HashMap();
        for (Method method : this.targetClass.getMethods()) {
            if (!method.getName().startsWith("is") && !method.getName().startsWith("get")) continue;
            boolean match = true;
            for (PropertyCriteria propertyCriteria : this.criteria) {
                if (propertyCriteria.methodMatches(method)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            MethodProperty property = Properties.createProperty(method);
            if (writable && property.isReadOnly()) continue;
            adapters.put(property.getName(), new PropertyAdapter(property));
        }
        for (Class<?> cls = this.targetClass; cls != null && !cls.equals(Object.class); cls = cls.getSuperclass()) {
            for (Field field : SecurityActions.getDeclaredFields(cls)) {
                boolean match = true;
                for (PropertyCriteria c : this.criteria) {
                    if (c.fieldMatches(field)) continue;
                    match = false;
                    break;
                }
                FieldProperty fieldProperty = Properties.createProperty(field);
                if (!match || writable && fieldProperty.isReadOnly()) continue;
                PropertyAdapter adapter = (PropertyAdapter)adapters.get(fieldProperty.getName());
                if (adapter != null) {
                    adapter.setProperty(fieldProperty);
                } else {
                    adapter = new PropertyAdapter(fieldProperty);
                }
                adapters.put(adapter.getName(), adapter);
            }
        }
        return Collections.unmodifiableList(new ArrayList(adapters.values()));
    }
}

