/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processor;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.jboss.as.jpa.config.PersistenceUnitMetadataHolder;
import org.jboss.as.jpa.service.PersistenceUnitServiceImpl;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.weld.spi.DeploymentUnitDependenciesProvider;
import org.jboss.msc.service.ServiceName;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;

public class JpaDependenciesProvider
implements DeploymentUnitDependenciesProvider {
    public Set<ServiceName> getDependencies(DeploymentUnit deploymentUnit) {
        HashSet<ServiceName> dependencies = new HashSet<ServiceName>();
        for (ResourceRoot root : DeploymentUtils.allResourceRoots((DeploymentUnit)deploymentUnit)) {
            PersistenceUnitMetadataHolder persistenceUnits = (PersistenceUnitMetadataHolder)root.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS);
            if (persistenceUnits == null || persistenceUnits.getPersistenceUnits() == null) continue;
            for (PersistenceUnitMetadata pu : persistenceUnits.getPersistenceUnits()) {
                Properties properties = pu.getProperties();
                String jpaContainerManaged = properties.getProperty("jboss.as.jpa.managed");
                boolean deployPU = jpaContainerManaged == null || Boolean.parseBoolean(jpaContainerManaged);
                if (!deployPU) continue;
                ServiceName serviceName = PersistenceUnitServiceImpl.getPUServiceName((PersistenceUnitMetadata)pu);
                dependencies.add(serviceName);
            }
        }
        return dependencies;
    }
}

