/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jgroups.blocks.Marshaller;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;
import org.wildfly.clustering.server.dispatcher.ChannelCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.dispatcher.NoSuchService;

public class CommandResponseMarshaller
implements Marshaller {
    private final ByteBufferMarshaller marshaller;
    private final ChannelFactory factory;

    CommandResponseMarshaller(ChannelCommandDispatcherFactoryConfiguration config) {
        this.marshaller = config.getMarshaller();
        this.factory = config.getChannelFactory();
    }

    public void objectToStream(Object object, DataOutput stream) throws IOException {
        ByteBuffer buffer = this.marshaller.write(object);
        int length = buffer.limit() - buffer.arrayOffset();
        IndexSerializer.VARIABLE.writeInt(stream, length);
        stream.write(buffer.array(), buffer.arrayOffset(), length);
    }

    public Object objectFromStream(DataInput stream) throws IOException {
        int size = IndexSerializer.VARIABLE.readInt(stream);
        byte[] bytes = new byte[size];
        stream.readFully(bytes);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        return this.factory.isUnknownForkResponse(buffer) ? NoSuchService.INSTANCE : this.marshaller.read(buffer);
    }
}

