/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.security.AccessController;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.ra.ConnectionFactoryProperties;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.service.ServiceContainer;
import org.wildfly.extension.messaging.activemq.ActiveMQServerService;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.broadcast.CommandDispatcherBroadcastEndpointFactory;
import org.wildfly.extension.messaging.activemq.jms.ExternalPooledConnectionFactoryService;
import org.wildfly.extension.messaging.activemq.jms.JMSServices;

public class ActiveMQResourceAdapter
extends org.apache.activemq.artemis.ra.ActiveMQResourceAdapter {
    private static final long serialVersionUID = 170278234232275756L;

    public ActiveMQResourceAdapter() {
        this.setEnable1xPrefixes(true);
        this.getProperties().setEnable1xPrefixes(Boolean.valueOf(true));
    }

    protected BroadcastEndpointFactory createBroadcastEndpointFactory(ConnectionFactoryProperties overrideProperties) {
        String clusterName;
        String string = clusterName = overrideProperties.getJgroupsChannelName() != null ? overrideProperties.getJgroupsChannelName() : this.getJgroupsChannelName();
        if (clusterName != null) {
            String channelRefName = this.getProperties().getJgroupsChannelRefName();
            String[] split = channelRefName.split("/");
            String serverName = split[0];
            String key = split[1];
            String pcf = null;
            if (key.indexOf(58) >= 0) {
                split = key.split(":");
                pcf = split[0];
                key = split[1];
            }
            if (serverName != null && !serverName.isEmpty()) {
                ActiveMQServerService service = (ActiveMQServerService)ActiveMQResourceAdapter.currentServiceContainer().getService(MessagingServices.getActiveMQServiceName(serverName)).getService();
                return new CommandDispatcherBroadcastEndpointFactory(service.getCommandDispatcherFactory(key), clusterName);
            }
            assert (pcf != null);
            ExternalPooledConnectionFactoryService service = (ExternalPooledConnectionFactoryService)ActiveMQResourceAdapter.currentServiceContainer().getService(JMSServices.getPooledConnectionFactoryBaseServiceName(MessagingServices.JBOSS_MESSAGING_ACTIVEMQ).append(new String[]{pcf})).getService();
            return new CommandDispatcherBroadcastEndpointFactory(service.getCommandDispatcherFactory(key), clusterName);
        }
        return super.createBroadcastEndpointFactory(overrideProperties);
    }

    private static ServiceContainer currentServiceContainer() {
        return System.getSecurityManager() == null ? CurrentServiceContainer.getServiceContainer() : (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }

    public WorkManager getWorkManager() {
        return new NamingWorkManager(super.getWorkManager());
    }

    private class WorkWrapper
    implements Work {
        private final Work delegate;
        private final NamespaceContextSelector selector;

        private WorkWrapper(NamespaceContextSelector selector, Work work) {
            this.selector = selector;
            this.delegate = work;
        }

        public void release() {
            NamespaceContextSelector.pushCurrentSelector((NamespaceContextSelector)this.selector);
            try {
                this.delegate.release();
            }
            finally {
                NamespaceContextSelector.popCurrentSelector();
            }
        }

        public void run() {
            NamespaceContextSelector.pushCurrentSelector((NamespaceContextSelector)this.selector);
            try {
                this.delegate.run();
            }
            finally {
                NamespaceContextSelector.popCurrentSelector();
            }
        }
    }

    private class NamingWorkManager
    implements WorkManager {
        private final WorkManager delegate;

        private NamingWorkManager(WorkManager delegate) {
            this.delegate = delegate;
        }

        public void doWork(Work work) throws WorkException {
            this.delegate.doWork(this.wrapWork(work));
        }

        public void doWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
            this.delegate.doWork(this.wrapWork(work), startTimeout, execContext, workListener);
        }

        public long startWork(Work work) throws WorkException {
            return this.delegate.startWork(this.wrapWork(work));
        }

        public long startWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
            return this.delegate.startWork(this.wrapWork(work), startTimeout, execContext, workListener);
        }

        public void scheduleWork(Work work) throws WorkException {
            this.delegate.scheduleWork(this.wrapWork(work));
        }

        public void scheduleWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
            this.delegate.scheduleWork(this.wrapWork(work), startTimeout, execContext, workListener);
        }

        private Work wrapWork(Work work) {
            return new WorkWrapper(NamespaceContextSelector.getCurrentSelector(), work);
        }
    }
}

