/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.QueueAbstractPacket;

public class SessionCreateConsumerMessage
extends QueueAbstractPacket {
    private long id;
    private SimpleString filterString;
    private int priority;
    private boolean browseOnly;
    private boolean requiresResponse;

    public SessionCreateConsumerMessage(long id, SimpleString queueName, SimpleString filterString, int priority, boolean browseOnly, boolean requiresResponse) {
        super((byte)40);
        this.id = id;
        this.queueName = queueName;
        this.filterString = filterString;
        this.priority = priority;
        this.browseOnly = browseOnly;
        this.requiresResponse = requiresResponse;
    }

    public SessionCreateConsumerMessage() {
        super((byte)40);
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(this.getParentString());
        buff.append(", queueName=" + this.queueName);
        buff.append(", filterString=" + this.filterString);
        buff.append(", id=" + this.id);
        buff.append(", browseOnly=" + this.browseOnly);
        buff.append(", requiresResponse=" + this.requiresResponse);
        buff.append(", priority=" + this.priority);
        buff.append("]");
        return buff.toString();
    }

    public long getID() {
        return this.id;
    }

    public SimpleString getFilterString() {
        return this.filterString;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isBrowseOnly() {
        return this.browseOnly;
    }

    @Override
    public boolean isRequiresResponse() {
        return this.requiresResponse;
    }

    public void setQueueName(SimpleString queueName) {
        this.queueName = queueName;
    }

    public void setFilterString(SimpleString filterString) {
        this.filterString = filterString;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    public void setBrowseOnly(boolean browseOnly) {
        this.browseOnly = browseOnly;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer, CoreRemotingConnection coreRemotingConnection) {
        buffer.writeLong(this.id);
        buffer.writeSimpleString(this.queueName);
        buffer.writeNullableSimpleString(this.filterString);
        buffer.writeBoolean(this.browseOnly);
        buffer.writeBoolean(this.requiresResponse);
        if (coreRemotingConnection.isVersionSupportConsumerPriority()) {
            buffer.writeInt(this.priority);
        }
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.id = buffer.readLong();
        this.queueName = buffer.readSimpleString();
        this.filterString = buffer.readNullableSimpleString();
        this.browseOnly = buffer.readBoolean();
        this.requiresResponse = buffer.readBoolean();
        this.priority = buffer.readableBytes() > 0 ? buffer.readInt() : ActiveMQDefaultConfiguration.getDefaultConsumerPriority();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.browseOnly ? 1231 : 1237);
        result = 31 * result + (this.filterString == null ? 0 : this.filterString.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.priority;
        result = 31 * result + (this.queueName == null ? 0 : this.queueName.hashCode());
        result = 31 * result + (this.requiresResponse ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionCreateConsumerMessage)) {
            return false;
        }
        SessionCreateConsumerMessage other = (SessionCreateConsumerMessage)obj;
        if (this.browseOnly != other.browseOnly) {
            return false;
        }
        if (this.filterString == null ? other.filterString != null : !this.filterString.equals(other.filterString)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.queueName == null ? other.queueName != null : !this.queueName.equals(other.queueName)) {
            return false;
        }
        return this.requiresResponse == other.requiresResponse;
    }
}

