/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.security.KeyStore;
import java.util.EnumSet;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityReference;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.clustering.controller.ResourceServiceConfiguratorFactory;
import org.jboss.as.clustering.jgroups.subsystem.EncryptProtocolConfigurationServiceConfigurator;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsModel;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.controller.security.CredentialReferenceWriteAttributeHandler;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelType;
import org.wildfly.clustering.service.UnaryRequirement;

public class EncryptProtocolResourceDefinition<E extends KeyStore.Entry>
extends ProtocolResourceDefinition {
    static void addTransformations(ModelVersion version, ResourceTransformationDescriptionBuilder builder) {
        if (JGroupsModel.VERSION_8_0_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().addRejectCheck(CredentialReference.REJECT_CREDENTIAL_REFERENCE_WITH_BOTH_STORE_AND_CLEAR_TEXT, new String[]{Attribute.KEY_CREDENTIAL.getName()})).end();
        }
        ProtocolResourceDefinition.addTransformations(version, builder);
    }

    public EncryptProtocolResourceDefinition(String name, Class<E> entryClass, UnaryOperator<ResourceDescriptor> configurator, ResourceServiceConfiguratorFactory parentServiceConfiguratorFactory) {
        super(EncryptProtocolResourceDefinition.pathElement(name), (UnaryOperator<ResourceDescriptor>)new ResourceDescriptorConfigurator(configurator), new EncryptProtocolConfigurationConfiguratorFactory<E>(entryClass), parentServiceConfiguratorFactory);
    }

    private static class EncryptProtocolConfigurationConfiguratorFactory<E extends KeyStore.Entry>
    implements ResourceServiceConfiguratorFactory {
        private final Class<E> entryClass;

        EncryptProtocolConfigurationConfiguratorFactory(Class<E> entryClass) {
            this.entryClass = entryClass;
        }

        public ResourceServiceConfigurator createServiceConfigurator(PathAddress address) {
            return new EncryptProtocolConfigurationServiceConfigurator(address, this.entryClass);
        }
    }

    private static class ResourceDescriptorConfigurator
    implements UnaryOperator<ResourceDescriptor> {
        private final UnaryOperator<ResourceDescriptor> configurator;

        ResourceDescriptorConfigurator(UnaryOperator<ResourceDescriptor> configurator) {
            this.configurator = configurator;
        }

        @Override
        public ResourceDescriptor apply(ResourceDescriptor descriptor) {
            return ((ResourceDescriptor)this.configurator.apply(descriptor)).addAttributes(EnumSet.complementOf(EnumSet.of(Attribute.KEY_CREDENTIAL))).addAttribute((org.jboss.as.clustering.controller.Attribute)Attribute.KEY_CREDENTIAL, (OperationStepHandler)new CredentialReferenceWriteAttributeHandler(Attribute.KEY_CREDENTIAL.getDefinition())).setAddOperationTransformation((UnaryOperator)new ProtocolResourceDefinition.LegacyAddOperationTransformation(Attribute.class)).setOperationTransformation(ProtocolResourceDefinition.LEGACY_OPERATION_TRANSFORMER);
        }
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        KEY_CREDENTIAL((AttributeDefinition)CredentialReference.getAttributeBuilder((String)"key-credential-reference", null, (boolean)false, (CapabilityReferenceRecorder)new CapabilityReference((Capability)ProtocolResourceDefinition.Capability.PROTOCOL, (UnaryRequirement)CommonUnaryRequirement.CREDENTIAL_STORE)).build()),
        KEY_ALIAS("key-alias", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setAllowExpression(true);
            }
        }
        ,
        KEY_STORE("key-store", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setCapabilityReference((CapabilityReferenceRecorder)new CapabilityReference((Capability)ProtocolResourceDefinition.Capability.PROTOCOL, (UnaryRequirement)CommonUnaryRequirement.KEY_STORE));
            }
        };

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type) {
            this.definition = this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setRequired(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        private Attribute(AttributeDefinition definition) {
            this.definition = definition;
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return builder;
        }
    }
}

