/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.time;

import java.io.IOException;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import org.infinispan.protostream.impl.WireFormat;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.time.LocalTimeMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.ZoneOffsetMarshaller;

public class OffsetTimeMarshaller
implements ProtoStreamMarshaller<OffsetTime> {
    private static final int TIME_INDEX = 1;
    private static final int OFFSET_INDEX = 1 + LocalTimeMarshaller.INSTANCE.getFields();

    @Override
    public OffsetTime readFrom(ProtoStreamReader reader) throws IOException {
        LocalTime time = LocalTimeMarshaller.INSTANCE.getBuilder();
        ZoneOffset offset = ZoneOffsetMarshaller.INSTANCE.getBuilder();
        boolean reading = true;
        while (reading) {
            int tag = reader.readTag();
            int index = WireFormat.getTagFieldNumber((int)tag);
            if (index >= 1 && index < OFFSET_INDEX) {
                time = LocalTimeMarshaller.INSTANCE.readField(reader, index - 1, time);
                continue;
            }
            if (index >= OFFSET_INDEX && index < OFFSET_INDEX + ZoneOffsetMarshaller.INSTANCE.getFields()) {
                offset = ZoneOffsetMarshaller.INSTANCE.readField(reader, index - OFFSET_INDEX, offset);
                continue;
            }
            reading = tag != 0 && reader.skipField(tag);
        }
        return OffsetTime.of(time, offset);
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, OffsetTime value) throws IOException {
        LocalTimeMarshaller.INSTANCE.writeFields(writer, 1, value.toLocalTime());
        ZoneOffsetMarshaller.INSTANCE.writeFields(writer, OFFSET_INDEX, value.getOffset());
    }

    @Override
    public Class<? extends OffsetTime> getJavaClass() {
        return OffsetTime.class;
    }
}

