/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent;

import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.util.Map;
import org.glassfish.enterprise.concurrent.ContextServiceImpl;
import org.glassfish.enterprise.concurrent.internal.ContextProxyInvocationHandler;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;

class IdentityAwareProxyInvocationHandler
extends ContextProxyInvocationHandler {
    private final transient SecurityIdentity securityIdentity;

    IdentityAwareProxyInvocationHandler(ContextServiceImpl contextService, Object proxiedObject, Map<String, String> executionProperties) {
        super(contextService, proxiedObject, executionProperties);
        SecurityDomain securityDomain = SecurityDomain.getCurrent();
        this.securityIdentity = securityDomain != null ? securityDomain.getCurrentSecurityIdentity() : null;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.securityIdentity != null) {
            try {
                return this.securityIdentity.runAs(() -> {
                    try {
                        return super.invoke(proxy, method, args);
                    }
                    catch (Throwable e) {
                        throw new WrapperException(e);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable cause = e.getCause();
                throw cause instanceof WrapperException ? cause.getCause() : cause;
            }
        }
        return super.invoke(proxy, method, args);
    }

    private static class WrapperException
    extends Exception {
        WrapperException(Throwable cause) {
            super(cause);
        }
    }
}

