/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.mirror;

import java.util.HashMap;
import java.util.List;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.server.mirror.MirrorController;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessageBrokerAccessor;
import org.apache.activemq.artemis.protocol.amqp.connect.AMQPBrokerConnection;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorMessageFactory;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.jboss.logging.Logger;

public class AMQPMirrorControllerSource
implements MirrorController,
ActiveMQComponent {
    private static final Logger logger = Logger.getLogger(AMQPMirrorControllerSource.class);
    public static final Symbol EVENT_TYPE = Symbol.getSymbol((String)"x-opt-amq-mr-ev-type");
    public static final Symbol ADDRESS = Symbol.getSymbol((String)"x-opt-amq-mr-adr");
    public static final Symbol QUEUE = Symbol.getSymbol((String)"x-opt-amq-mr-qu");
    public static final Symbol ADD_ADDRESS = Symbol.getSymbol((String)"addAddress");
    public static final Symbol DELETE_ADDRESS = Symbol.getSymbol((String)"deleteAddress");
    public static final Symbol CREATE_QUEUE = Symbol.getSymbol((String)"createQueue");
    public static final Symbol DELETE_QUEUE = Symbol.getSymbol((String)"deleteQueue");
    public static final Symbol ADDRESS_SCAN_START = Symbol.getSymbol((String)"addressCanStart");
    public static final Symbol ADDRESS_SCAN_END = Symbol.getSymbol((String)"addressScanEnd");
    public static final Symbol POST_ACK = Symbol.getSymbol((String)"postAck");
    public static final Symbol INTERNAL_ID = Symbol.getSymbol((String)"x-opt-amq-mr-id");
    public static final Symbol INTERNAL_DESTINATION = Symbol.getSymbol((String)"x-opt-amq-mr-dst");
    private static final ThreadLocal<MirrorControlRouting> mirrorControlRouting = ThreadLocal.withInitial(() -> new MirrorControlRouting(null));
    final Queue snfQueue;
    final ActiveMQServer server;
    final boolean acks;
    final boolean addQueues;
    final boolean deleteQueues;
    private final AMQPBrokerConnection brokerConnection;
    boolean started;

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public boolean isStarted() {
        return this.started;
    }

    public AMQPMirrorControllerSource(Queue snfQueue, ActiveMQServer server, boolean acks, boolean addQueues, boolean deleteQueues, AMQPBrokerConnection brokerConnection) {
        this.snfQueue = snfQueue;
        this.server = server;
        this.acks = acks;
        this.addQueues = addQueues;
        this.deleteQueues = deleteQueues;
        this.brokerConnection = brokerConnection;
    }

    public Queue getSnfQueue() {
        return this.snfQueue;
    }

    public AMQPBrokerConnection getBrokerConnection() {
        return this.brokerConnection;
    }

    public void startAddressScan() throws Exception {
        Message message = this.createMessage(null, null, ADDRESS_SCAN_START, null);
        AMQPMirrorControllerSource.route(this.server, message);
    }

    public void endAddressScan() throws Exception {
        Message message = this.createMessage(null, null, ADDRESS_SCAN_END, null);
        AMQPMirrorControllerSource.route(this.server, message);
    }

    public void addAddress(AddressInfo addressInfo) throws Exception {
        if (this.addQueues) {
            Message message = this.createMessage(addressInfo.getName(), null, ADD_ADDRESS, addressInfo.toJSON());
            AMQPMirrorControllerSource.route(this.server, message);
        }
    }

    public void deleteAddress(AddressInfo addressInfo) throws Exception {
        if (this.deleteQueues) {
            Message message = this.createMessage(addressInfo.getName(), null, DELETE_ADDRESS, addressInfo.toJSON());
            AMQPMirrorControllerSource.route(this.server, message);
        }
    }

    public void createQueue(QueueConfiguration queueConfiguration) throws Exception {
        if (this.addQueues) {
            Message message = this.createMessage(queueConfiguration.getAddress(), queueConfiguration.getName(), CREATE_QUEUE, queueConfiguration.toJSON());
            AMQPMirrorControllerSource.route(this.server, message);
        }
    }

    public void deleteQueue(SimpleString address, SimpleString queue) throws Exception {
        if (this.deleteQueues) {
            Message message = this.createMessage(address, queue, DELETE_QUEUE, queue.toString());
            AMQPMirrorControllerSource.route(this.server, message);
        }
    }

    public void sendMessage(Message message, RoutingContext context, List<MessageReference> refs) {
        try {
            Properties amqpProperties;
            context.setReusable(false);
            PagingStore storeOwner = null;
            if (refs.size() > 0) {
                storeOwner = refs.get(0).getOwner();
            }
            if (storeOwner != null && !storeOwner.getAddress().equals((Object)message.getAddressSimpleString())) {
                storeOwner = this.server.getPagingManager().getPageStore(message.getAddressSimpleString());
            }
            MessageReference ref = MessageReference.Factory.createReference((Message)message, (Queue)this.snfQueue, (PagingStore)storeOwner);
            this.snfQueue.refUp(ref);
            HashMap<Symbol, Object> daMap = new HashMap<Symbol, Object>();
            DeliveryAnnotations deliveryAnnotations = new DeliveryAnnotations(daMap);
            daMap.put(INTERNAL_ID, message.getMessageID());
            String address = message.getAddress();
            if (!(address == null || (amqpProperties = AMQPMirrorControllerSource.getProperties(message)) != null && address.equals(amqpProperties.getTo()))) {
                daMap.put(INTERNAL_DESTINATION, message.getAddress());
            }
            ref.setProtocolData((Object)deliveryAnnotations);
            refs.add(ref);
            message.usageUp();
        }
        catch (Throwable e) {
            logger.warn((Object)e.getMessage(), e);
        }
    }

    private static Properties getProperties(Message message) {
        if (message instanceof AMQPMessage) {
            return AMQPMessageBrokerAccessor.getCurrentProperties((AMQPMessage)message);
        }
        return null;
    }

    public void postAcknowledge(MessageReference ref, AckReason reason) throws Exception {
        if (this.acks && !ref.getQueue().isMirrorController()) {
            Message message = this.createMessage(ref.getQueue().getAddress(), ref.getQueue().getName(), POST_ACK, ref.getMessage().getMessageID());
            AMQPMirrorControllerSource.route(this.server, message);
            ref.getMessage().usageDown();
        }
    }

    private Message createMessage(SimpleString address, SimpleString queue, Object event, Object body) {
        return AMQPMirrorMessageFactory.createMessage(this.snfQueue.getAddress().toString(), address, queue, event, body);
    }

    public static void route(ActiveMQServer server, Message message) throws Exception {
        message.setMessageID(server.getStorageManager().generateID());
        MirrorControlRouting ctx = mirrorControlRouting.get();
        ctx.clear();
        server.getPostOffice().route(message, (RoutingContext)ctx, false);
    }

    private static class MirrorControlRouting
    extends RoutingContextImpl {
        MirrorControlRouting(Transaction transaction) {
            super(transaction);
        }

        public boolean isMirrorController() {
            return true;
        }
    }
}

