/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.sasl;

import java.io.IOException;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginContext;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.activemq.artemis.protocol.amqp.sasl.PrincipalSASLResult;
import org.apache.activemq.artemis.protocol.amqp.sasl.SASLResult;
import org.apache.activemq.artemis.protocol.amqp.sasl.ServerSASL;
import org.jboss.logging.Logger;

public class GSSAPIServerSASL
implements ServerSASL {
    private static final Logger log = Logger.getLogger(GSSAPIServerSASL.class);
    public static final String NAME = "GSSAPI";
    private String loginConfigScope;
    private SaslServer saslServer;
    private Subject jaasId;
    private SASLResult result;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte[] processSASL(byte[] bytes) {
        try {
            if (this.jaasId == null) {
                LoginContext loginContext = new LoginContext(this.loginConfigScope);
                loginContext.login();
                this.jaasId = loginContext.getSubject();
            }
            if (this.saslServer == null) {
                this.saslServer = Subject.doAs(this.jaasId, () -> Sasl.createSaslServer(NAME, null, null, new HashMap(), new CallbackHandler(){

                    @Override
                    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                        for (Callback callback : callbacks) {
                            if (!(callback instanceof AuthorizeCallback)) continue;
                            AuthorizeCallback authorizeCallback = (AuthorizeCallback)callback;
                            authorizeCallback.setAuthorized(authorizeCallback.getAuthenticationID().equals(authorizeCallback.getAuthorizationID()));
                        }
                    }
                }));
            }
            byte[] challenge = Subject.doAs(this.jaasId, () -> this.saslServer.evaluateResponse(bytes));
            if (this.saslServer.isComplete()) {
                this.result = new PrincipalSASLResult(true, new KerberosPrincipal(this.saslServer.getAuthorizationID()));
            }
            return challenge;
        }
        catch (Exception outOfHere) {
            log.info((Object)("Error on sasl input: " + outOfHere.toString()), (Throwable)outOfHere);
            this.result = new PrincipalSASLResult(false, null);
            return null;
        }
    }

    @Override
    public SASLResult result() {
        return this.result;
    }

    @Override
    public void done() {
        if (this.saslServer != null) {
            try {
                this.saslServer.dispose();
            }
            catch (SaslException error) {
                log.debug((Object)"Exception on sasl dispose", (Throwable)error);
            }
        }
    }

    public String getLoginConfigScope() {
        return this.loginConfigScope;
    }

    public void setLoginConfigScope(String loginConfigScope) {
        this.loginConfigScope = loginConfigScope;
    }
}

