/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.PrivilegedActionException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.StartException;
import org.wildfly.common.function.ExceptionConsumer;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.elytron.AggregateComponentDefinition;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.DoohickeyAddHandler;
import org.wildfly.extension.elytron.ElytronDoohickey;
import org.wildfly.extension.elytron.ElytronRuntimeOnlyHandler;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.ProviderAttributeDefinition;
import org.wildfly.extension.elytron.SecurityActions;
import org.wildfly.extension.elytron.TrivialResourceDefinition;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;

class ProviderDefinitions {
    static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", FileAttributeDefinitions.PATH).setAttributeGroup("configuration")).setAlternatives(new String[]{"configuration"})).setRestartAllServices()).build();
    static final SimpleAttributeDefinition RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("relative-to", FileAttributeDefinitions.RELATIVE_TO).setAttributeGroup("configuration")).setRequires(new String[]{"path"})).setRestartAllServices()).build();
    static final SimpleMapAttributeDefinition CONFIGURATION = ((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("configuration", ModelType.STRING, true).setAttributeGroup("configuration")).setAllowExpression(true)).setAlternatives(new String[]{"path", "argument"})).setRestartAllServices()).build();
    static final SimpleAttributeDefinition ARGUMENT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("argument", ModelType.STRING, true).setAttributeGroup("configuration")).setRequires(new String[]{"class-names"})).setAlternatives(new String[]{"path", "configuration"})).setAllowExpression(true)).setRestartAllServices()).build();
    private static final AggregateComponentDefinition<Provider[]> AGGREGATE_PROVIDERS = AggregateComponentDefinition.create(Provider[].class, "aggregate-providers", "providers", Capabilities.PROVIDERS_RUNTIME_CAPABILITY, "org.wildfly.security.providers-api", ProviderDefinitions::aggregate, false);
    static final ListAttributeDefinition REFERENCES = AGGREGATE_PROVIDERS.getReferencesAttribute();

    ProviderDefinitions() {
    }

    static AggregateComponentDefinition<Provider[]> getAggregateProvidersDefinition() {
        return AGGREGATE_PROVIDERS;
    }

    static ResourceDefinition getProviderLoaderDefinition(boolean serverOrHostController) {
        AttributeDefinition[] attributes = new AttributeDefinition[]{ClassLoadingAttributeDefinitions.MODULE, ClassLoadingAttributeDefinitions.CLASS_NAMES, PATH, RELATIVE_TO, ARGUMENT, CONFIGURATION};
        DoohickeyAddHandler<Provider[]> add = new DoohickeyAddHandler<Provider[]>(Capabilities.PROVIDERS_RUNTIME_CAPABILITY, attributes, "org.wildfly.security.providers-api"){

            @Override
            protected ElytronDoohickey<Provider[]> createDoohickey(PathAddress resourceAddress) {
                return new ElytronDoohickey<Provider[]>(resourceAddress){
                    private volatile String module;
                    private volatile String[] classNames;
                    private volatile String path;
                    private volatile String relativeTo;
                    private volatile String argument;
                    private volatile Properties properties;

                    @Override
                    protected void resolveRuntime(ModelNode model, OperationContext context) throws OperationFailedException {
                        this.module = ClassLoadingAttributeDefinitions.MODULE.resolveModelAttribute(context, model).asStringOrNull();
                        ModelNode classNamesNode = ClassLoadingAttributeDefinitions.CLASS_NAMES.resolveModelAttribute(context, model);
                        if (classNamesNode.isDefined()) {
                            List values = classNamesNode.asList();
                            this.classNames = new String[values.size()];
                            for (int i = 0; i < this.classNames.length; ++i) {
                                this.classNames[i] = ((ModelNode)values.get(i)).asString();
                            }
                        } else {
                            this.classNames = null;
                        }
                        this.path = PATH.resolveModelAttribute(context, model).asStringOrNull();
                        this.relativeTo = RELATIVE_TO.resolveModelAttribute(context, model).asStringOrNull();
                        this.argument = ARGUMENT.resolveModelAttribute(context, model).asStringOrNull();
                        ModelNode configuration = CONFIGURATION.resolveModelAttribute(context, model);
                        if (configuration.isDefined()) {
                            this.properties = new Properties();
                            for (String s : configuration.keys()) {
                                this.properties.setProperty(s, configuration.require(s).asString());
                            }
                        } else {
                            this.properties = null;
                        }
                    }

                    @Override
                    protected ExceptionSupplier<Provider[], StartException> prepareServiceSupplier(OperationContext context, CapabilityServiceBuilder<?> serviceBuilder) throws OperationFailedException {
                        Supplier pathManager;
                        if (this.properties == null && this.relativeTo != null) {
                            pathManager = serviceBuilder.requires(PathManagerService.SERVICE_NAME);
                            serviceBuilder.requires(FileAttributeDefinitions.pathName(this.relativeTo));
                        } else {
                            pathManager = null;
                        }
                        return new ExceptionSupplier<Provider[], StartException>(){

                            public Provider[] get() throws StartException {
                                File resolved = null;
                                if (properties == null && relativeTo != null) {
                                    FileAttributeDefinitions.PathResolver pathResolver = FileAttributeDefinitions.pathResolver();
                                    pathResolver.path(path);
                                    if (relativeTo != null) {
                                        pathResolver.relativeTo(relativeTo, (PathManager)pathManager.get());
                                    }
                                    resolved = pathResolver.resolve();
                                    pathResolver.clear();
                                }
                                return this.loadProviders(resolved);
                            }
                        };
                    }

                    @Override
                    protected Provider[] createImmediately(OperationContext foreignContext) throws OperationFailedException {
                        File resolvedPath = null;
                        if (this.properties == null && this.path != null) {
                            resolvedPath = this.resolveRelativeToImmediately(this.path, this.relativeTo, foreignContext);
                        }
                        try {
                            return this.loadProviders(resolvedPath);
                        }
                        catch (StartException e) {
                            throw new OperationFailedException((Throwable)e);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     */
                    private Provider[] loadProviders(File resolvedPath) throws StartException {
                        Supplier configSupplier = this.properties != null ? ProviderDefinitions.getConfigurationSupplier(this.properties) : (resolvedPath != null ? ProviderDefinitions.getConfigurationSupplier(resolvedPath) : null);
                        try {
                            Object[] providers;
                            ArrayList<Object> loadedProviders;
                            ArrayList<ExceptionConsumer> deferred = new ArrayList<ExceptionConsumer>();
                            ClassLoader classLoader = SecurityActions.doPrivileged(() -> ClassLoadingAttributeDefinitions.resolveClassLoader(this.module));
                            if (this.classNames != null) {
                                void var8_14;
                                loadedProviders = new ArrayList(this.classNames.length);
                                String[] stringArray = this.classNames;
                                int n = stringArray.length;
                                boolean bl = false;
                                while (var8_14 < n) {
                                    Constructor constructor;
                                    String className = stringArray[var8_14];
                                    Class<Provider> providerClazz = classLoader.loadClass(className).asSubclass(Provider.class);
                                    if (this.argument != null) {
                                        constructor = SecurityActions.doPrivileged(() -> providerClazz.getConstructor(String.class));
                                        loadedProviders.add(constructor.newInstance(this.argument));
                                    } else if (configSupplier != null) {
                                        try {
                                            constructor = SecurityActions.doPrivileged(() -> providerClazz.getConstructor(InputStream.class));
                                            loadedProviders.add(constructor.newInstance(configSupplier.get()));
                                        }
                                        catch (NoSuchMethodException constructorDoesNotExist) {
                                            Provider provider;
                                            File tempFile = null;
                                            try {
                                                Method configureMethod = SecurityActions.doPrivileged(() -> providerClazz.getMethod("configure", String.class));
                                                provider = providerClazz.newInstance();
                                                tempFile = ProviderDefinitions.inputStreamToFile(configSupplier);
                                                loadedProviders.add((Provider)configureMethod.invoke((Object)provider, tempFile.getAbsolutePath()));
                                            }
                                            catch (NoSuchMethodException configureMethodDoesNotExist) {
                                                provider = providerClazz.newInstance();
                                                loadedProviders.add(provider);
                                                deferred.add(provider::load);
                                            }
                                            finally {
                                                if (tempFile != null) {
                                                    tempFile.delete();
                                                }
                                            }
                                        }
                                    } else {
                                        loadedProviders.add(providerClazz.newInstance());
                                    }
                                    ++var8_14;
                                }
                            } else {
                                loadedProviders = new ArrayList<Object>();
                                try {
                                    providers = Module.findServices(Provider.class, (Predicate)new Predicate<Class<?>>(){

                                        @Override
                                        public boolean test(Class<?> providerClass) {
                                            return providerClass.getClassLoader() instanceof ModuleClassLoader;
                                        }
                                    }, (ClassLoader)classLoader);
                                    for (Provider provider : providers) {
                                        if (configSupplier != null) {
                                            deferred.add(provider::load);
                                        }
                                        loadedProviders.add(provider);
                                    }
                                }
                                catch (Exception e) {
                                    ElytronSubsystemMessages.ROOT_LOGGER.tracef(e, "Failed to initialize a security provider", new Object[0]);
                                }
                            }
                            for (ExceptionConsumer current : deferred) {
                                current.accept(configSupplier.get());
                            }
                            providers = loadedProviders.toArray(new Provider[loadedProviders.size()]);
                            if (ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) {
                                ElytronSubsystemMessages.ROOT_LOGGER.tracef("Loaded providers %s", Arrays.toString(providers));
                            }
                            return providers;
                        }
                        catch (PrivilegedActionException e) {
                            throw new StartException(e.getCause());
                        }
                        catch (Exception e) {
                            throw new StartException((Throwable)e);
                        }
                    }
                };
            }

            @Override
            protected boolean dependOnProviderRegistration() {
                return false;
            }
        };
        TrivialResourceDefinition.Builder builder = TrivialResourceDefinition.builder().setPathKey("provider-loader").setAddHandler(add).setAttributes(attributes).setRuntimeCapabilities(Capabilities.PROVIDERS_RUNTIME_CAPABILITY);
        if (serverOrHostController) {
            builder.addReadOnlyAttribute((AttributeDefinition)ProviderAttributeDefinition.LOADED_PROVIDERS, new LoadedProvidersAttributeHandler());
        }
        return builder.build();
    }

    private static Provider[] aggregate(Provider[] ... providers) {
        int length = 0;
        for (Provider[] current : providers) {
            length += current.length;
        }
        Provider[] combined = new Provider[length];
        int startPos = 0;
        for (Provider[] current : providers) {
            System.arraycopy(current, 0, combined, startPos, current.length);
            startPos += current.length;
        }
        return combined;
    }

    private static Supplier<InputStream> getConfigurationSupplier(File location) throws StartException {
        try {
            byte[] configuration = Files.readAllBytes(location.toPath());
            return () -> new ByteArrayInputStream(configuration);
        }
        catch (IOException e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToStartService(e);
        }
    }

    private static Supplier<InputStream> getConfigurationSupplier(Properties properties) throws StartException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            properties.store(baos, "");
            byte[] configuration = baos.toByteArray();
            return () -> new ByteArrayInputStream(configuration);
        }
        catch (IOException e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToStartService(e);
        }
    }

    private static File inputStreamToFile(Supplier<InputStream> configSupplier) throws IOException {
        File tempFile = new File(Files.createTempFile("temp", "cfg", new FileAttribute[0]).toString());
        InputStream inputStream = configSupplier.get();
        byte[] buffer = new byte[inputStream.available()];
        inputStream.read(buffer);
        FileOutputStream outStream = new FileOutputStream(tempFile);
        ((OutputStream)outStream).write(buffer);
        ((OutputStream)outStream).close();
        return tempFile;
    }

    private static class LoadedProvidersAttributeHandler
    extends ElytronRuntimeOnlyHandler {
        private LoadedProvidersAttributeHandler() {
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            ExceptionFunction providerApi = (ExceptionFunction)context.getCapabilityRuntimeAPI("org.wildfly.security.providers-api", context.getCurrentAddressValue(), ExceptionFunction.class);
            ProviderAttributeDefinition.populateProviders(context.getResult(), (Provider[])providerApi.apply((Object)context));
        }
    }
}

