/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.OptionalInt;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.TagWriter;
import org.infinispan.protostream.impl.TagWriterImpl;
import org.wildfly.clustering.marshalling.protostream.AbstractProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.Marshallable;
import org.wildfly.clustering.marshalling.spi.ByteBufferOutputStream;

public class DefaultProtoStreamWriter
extends AbstractProtoStreamWriter {
    public DefaultProtoStreamWriter(ProtobufTagMarshaller.WriteContext context) {
        super(context);
    }

    @Override
    public void writeObjectNoTag(Object value) throws IOException {
        ProtobufTagMarshaller marshaller = this.findMarshaller(value.getClass());
        ImmutableSerializationContext context = this.getSerializationContext();
        OptionalInt size = marshaller instanceof Marshallable ? ((Marshallable)marshaller).size(context, value) : OptionalInt.empty();
        try (ByteBufferOutputStream output = new ByteBufferOutputStream(size);){
            TagWriterImpl writer = size.isPresent() ? TagWriterImpl.newInstance((ImmutableSerializationContext)context, (OutputStream)output, (int)size.getAsInt()) : TagWriterImpl.newInstance((ImmutableSerializationContext)context, (OutputStream)output);
            marshaller.write(new ProtobufTagMarshaller.WriteContext((TagWriter)writer){
                final /* synthetic */ TagWriter val$writer;
                {
                    this.val$writer = tagWriter;
                }

                public ImmutableSerializationContext getSerializationContext() {
                    return DefaultProtoStreamWriter.this.getSerializationContext();
                }

                public Object getParam(Object key) {
                    return DefaultProtoStreamWriter.this.getParam(key);
                }

                public void setParam(Object key, Object value) {
                    DefaultProtoStreamWriter.this.setParam(key, value);
                }

                public TagWriter getWriter() {
                    return this.val$writer;
                }
            }, value);
            writer.flush();
            ByteBuffer buffer = output.getBuffer();
            int offset = buffer.arrayOffset();
            int length = buffer.limit() - offset;
            this.getWriter().writeVarint32(length);
            this.getWriter().writeRawBytes(buffer.array(), offset, length);
        }
    }
}

