/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.Any;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class ExceptionMarshaller<E extends Throwable>
implements ProtoStreamMarshaller<E> {
    private static final int CLASS_INDEX = 1;
    private static final int MESSAGE_INDEX = 2;
    private static final int CAUSE_INDEX = 3;
    private static final int STACK_TRACE_ELEMENT_INDEX = 4;
    private static final int SUPPRESSED_INDEX = 5;
    private final Class<E> exceptionClass;

    public ExceptionMarshaller(Class<E> exceptionClass) {
        this.exceptionClass = exceptionClass;
    }

    @Override
    public Class<? extends E> getJavaClass() {
        return this.exceptionClass;
    }

    @Override
    public E readFrom(ProtoStreamReader reader) throws IOException {
        Class exceptionClass = this.exceptionClass;
        String message = null;
        Throwable cause = null;
        LinkedList<StackTraceElement> stackTrace = new LinkedList<StackTraceElement>();
        LinkedList<Throwable> suppressed = new LinkedList<Throwable>();
        block7: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    exceptionClass = reader.readObject(Class.class);
                    continue block7;
                }
                case 2: {
                    message = reader.readString();
                    continue block7;
                }
                case 3: {
                    cause = (Throwable)reader.readObject(Any.class).get();
                    continue block7;
                }
                case 4: {
                    stackTrace.add(reader.readObject(StackTraceElement.class));
                    continue block7;
                }
                case 5: {
                    suppressed.add((Throwable)reader.readObject(Any.class).get());
                    continue block7;
                }
            }
            reader.skipField(tag);
        }
        E exception = this.createException(exceptionClass, message, cause);
        if (!stackTrace.isEmpty()) {
            ((Throwable)exception).setStackTrace(stackTrace.toArray(new StackTraceElement[0]));
        }
        for (Throwable e : suppressed) {
            ((Throwable)exception).addSuppressed(e);
        }
        return exception;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, E exception) throws IOException {
        if (this.exceptionClass == Throwable.class) {
            writer.writeObject(1, exception.getClass());
        }
        String message = ((Throwable)exception).getMessage();
        Throwable cause = ((Throwable)exception).getCause();
        if (!(message == null || cause != null && cause.toString().equals(message))) {
            writer.writeString(2, message);
        }
        if (cause != null) {
            writer.writeObject(3, new Any(cause));
        }
        for (StackTraceElement stackTraceElement : ((Throwable)exception).getStackTrace()) {
            writer.writeObject(4, stackTraceElement);
        }
        for (Serializable serializable : ((Throwable)exception).getSuppressed()) {
            writer.writeObject(5, new Any(serializable));
        }
    }

    private E createException(Class<E> exceptionClass, String message, Throwable cause) throws IOException {
        Constructor<E> emptyConstructor = this.getConstructor(exceptionClass, new Class[0]);
        Constructor<E> messageConstructor = this.getConstructor(exceptionClass, String.class);
        Constructor<E> causeConstructor = this.getConstructor(exceptionClass, Throwable.class);
        Constructor<E> messageCauseConstructor = this.getConstructor(exceptionClass, String.class, Throwable.class);
        try {
            Throwable exception;
            if (cause != null) {
                if (message != null) {
                    if (messageCauseConstructor != null) {
                        return (E)((Throwable)messageCauseConstructor.newInstance(message, cause));
                    }
                } else if (causeConstructor != null) {
                    return (E)((Throwable)causeConstructor.newInstance(cause));
                }
            }
            Throwable throwable = message != null ? (messageConstructor != null ? (Throwable)messageConstructor.newInstance(message) : null) : (exception = emptyConstructor != null ? (Throwable)emptyConstructor.newInstance(new Object[0]) : null);
            if (exception == null) {
                throw new NoSuchMethodException(String.format("%s(%s)", exceptionClass.getName(), message != null ? String.class.getName() : ""));
            }
            if (cause != null) {
                exception.initCause(cause);
            }
            return (E)exception;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException(e);
        }
    }

    private Constructor<E> getConstructor(Class<E> exceptionClass, Class<?> ... parameterTypes) {
        try {
            return exceptionClass.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

