/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.util.OptionalInt;
import java.util.function.Supplier;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.TagWriter;
import org.infinispan.protostream.impl.TagWriterImpl;
import org.wildfly.clustering.marshalling.protostream.AbstractProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.Marshallable;

public class SizeComputingProtoStreamWriter
extends AbstractProtoStreamWriter
implements Supplier<OptionalInt> {
    private boolean present = true;

    public SizeComputingProtoStreamWriter(ImmutableSerializationContext context) {
        this(context, (TagWriter)TagWriterImpl.newInstance((ImmutableSerializationContext)context));
    }

    private SizeComputingProtoStreamWriter(final ImmutableSerializationContext context, final TagWriter writer) {
        super(new ProtobufTagMarshaller.WriteContext(){

            public ImmutableSerializationContext getSerializationContext() {
                return context;
            }

            public Object getParam(Object key) {
                return null;
            }

            public void setParam(Object key, Object value) {
            }

            public TagWriter getWriter() {
                return writer;
            }
        });
    }

    @Override
    public OptionalInt get() {
        return this.present ? OptionalInt.of(((TagWriterImpl)this.getWriter()).getWrittenBytes()) : OptionalInt.empty();
    }

    @Override
    public void writeObjectNoTag(Object value) throws IOException {
        if (this.present) {
            OptionalInt size;
            ProtobufTagMarshaller marshaller = this.findMarshaller(value.getClass());
            OptionalInt optionalInt = size = marshaller instanceof Marshallable ? ((Marshallable)marshaller).size(this.getSerializationContext(), value) : OptionalInt.empty();
            if (size.isPresent()) {
                int length = size.getAsInt();
                this.writeVarint32(length);
                this.writeRawBytes(null, 0, length);
            } else {
                this.present = false;
            }
        }
    }
}

