/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mw.wst11.service;

import com.arjuna.mw.wst11.service.JaxBaseHeaderContextProcessor;
import com.arjuna.mw.wstx.logging.wstxLogger;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public class JaxWSHeaderContextProcessor
extends JaxBaseHeaderContextProcessor
implements SOAPHandler<SOAPMessageContext> {
    public boolean handleMessage(SOAPMessageContext msgContext) {
        Boolean outbound = (Boolean)msgContext.get((Object)"javax.xml.ws.handler.message.outbound");
        if (outbound == null) {
            throw new IllegalStateException("Cannot obtain required property: javax.xml.ws.handler.message.outbound");
        }
        return outbound != false ? this.handleOutbound(msgContext) : this.handleInbound(msgContext);
    }

    public boolean handleFault(SOAPMessageContext messageContext) {
        if (wstxLogger.logger.isTraceEnabled()) {
            wstxLogger.logger.trace((Object)"service/JaxWSHeaderContextProcessor.handleFault()");
            wstxLogger.traceMessage(messageContext);
        }
        this.suspendTransaction();
        return true;
    }

    public void close(MessageContext messageContext) {
    }

    public Set<QName> getHeaders() {
        HashSet<QName> headerSet = new HashSet<QName>();
        headerSet.add(new QName("http://docs.oasis-open.org/ws-tx/wscoor/2006/06", "CoordinationContext"));
        return headerSet;
    }

    public void setHeaders(Set headers) {
    }

    protected boolean handleInbound(SOAPMessageContext msgContext) {
        if (wstxLogger.logger.isTraceEnabled()) {
            wstxLogger.logger.trace((Object)"service/JaxWSHeaderContextProcessor.handleInbound()");
            wstxLogger.traceMessage(msgContext);
        }
        SOAPMessageContext soapMessageContext = msgContext;
        SOAPMessage soapMessage = soapMessageContext.getMessage();
        return this.handleInboundMessage(soapMessage);
    }

    protected boolean handleOutbound(SOAPMessageContext messageContext) {
        if (wstxLogger.logger.isTraceEnabled()) {
            wstxLogger.logger.trace((Object)"service/JaxWSHeaderContextProcessor.handleOutbound()");
            wstxLogger.traceMessage(messageContext);
        }
        this.suspendTransaction();
        return true;
    }
}

