/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices;

import com.arjuna.webservices.SoapFaultType;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.xml.namespace.QName;

public class SoapFault
extends Exception {
    private static final long serialVersionUID = -5256882376188382002L;
    protected SoapFaultType soapFaultType;
    protected QName subcode;
    protected QName subSubcode;
    protected String reason;
    protected String node;
    protected String detail;
    protected String role;
    protected boolean headerFault;
    protected String action;

    protected SoapFault() {
    }

    protected SoapFault(Throwable th) {
        this(SoapFaultType.FAULT_RECEIVER, null, th.toString(), SoapFault.generateStackTrace(th));
    }

    protected SoapFault(SoapFaultType soapFaultType, QName subcode, String reason) {
        this(soapFaultType, subcode, reason, null);
    }

    protected SoapFault(SoapFaultType soapFaultType, String reason) {
        this(soapFaultType, null, reason, null);
    }

    protected SoapFault(SoapFaultType soapFaultType, String reason, String detail) {
        this(soapFaultType, null, reason, detail);
    }

    protected SoapFault(SoapFaultType soapFaultType, QName subcode, String reason, String detail) {
        this.soapFaultType = soapFaultType;
        this.subcode = subcode;
        this.reason = reason;
        this.detail = detail;
    }

    public SoapFaultType getSoapFaultType() {
        return this.soapFaultType;
    }

    public void setSoapFaultType(SoapFaultType soapFaultType) {
        this.soapFaultType = soapFaultType;
    }

    public QName getSubcode() {
        return this.subcode;
    }

    public void setSubcode(QName subcode) {
        this.subcode = subcode;
    }

    public QName getSubSubcode() {
        return this.subSubcode;
    }

    public void setSubSubcode(QName subSubcode) {
        this.subSubcode = subSubcode;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public boolean isHeaderFault() {
        return this.headerFault;
    }

    public void setHeaderFault(boolean headerFault) {
        this.headerFault = headerFault;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    @Override
    public String getMessage() {
        StringBuffer buffer = new StringBuffer(this.soapFaultType.getValue());
        if (this.subcode != null) {
            buffer.append('[');
            buffer.append(this.subcode);
            if (this.subSubcode != null) {
                buffer.append(':');
                buffer.append(this.subSubcode);
            }
            buffer.append(']');
        }
        if (this.reason != null) {
            buffer.append('[');
            buffer.append(this.reason);
            buffer.append(']');
        }
        if (this.detail != null) {
            buffer.append('[');
            buffer.append(this.detail);
            buffer.append(']');
        }
        return buffer.toString();
    }

    public static String generateStackTrace(Throwable th) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        th.printStackTrace(pw);
        if (!pw.checkError()) {
            pw.close();
            return writer.toString();
        }
        return null;
    }
}

