/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.validator;

import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.cxf.rt.security.claims.ClaimCollection;
import org.apache.cxf.rt.security.saml.claims.SAMLSecurityContext;
import org.apache.cxf.rt.security.saml.utils.SAMLUtils;
import org.apache.cxf.sts.token.validator.DefaultSubjectRoleParser;
import org.apache.cxf.sts.token.validator.SAMLRoleParser;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;

public class DefaultSAMLRoleParser
extends DefaultSubjectRoleParser
implements SAMLRoleParser {
    public static final String SAML_ROLE_ATTRIBUTENAME_DEFAULT = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/role";
    private boolean useJaasSubject = true;
    private String roleAttributeName = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/role";

    @Override
    public Set<Principal> parseRolesFromAssertion(Principal principal, Subject subject, SamlAssertionWrapper assertion) {
        if (subject != null && this.useJaasSubject) {
            return super.parseRolesFromSubject(principal, subject);
        }
        ClaimCollection claims = SAMLUtils.getClaims((SamlAssertionWrapper)assertion);
        Set roles = SAMLUtils.parseRolesFromClaims((ClaimCollection)claims, (String)this.roleAttributeName, null);
        SAMLSecurityContext context = new SAMLSecurityContext(principal, roles, claims);
        return context.getUserRoles();
    }

    public boolean isUseJaasSubject() {
        return this.useJaasSubject;
    }

    public void setUseJaasSubject(boolean useJaasSubject) {
        this.useJaasSubject = useJaasSubject;
    }

    public String getRoleAttributeName() {
        return this.roleAttributeName;
    }

    public void setRoleAttributeName(String roleAttributeName) {
        this.roleAttributeName = roleAttributeName;
    }
}

