/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.certs;

import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.X509Certificate;
import org.jboss.security.CertificatePrincipal;
import org.jboss.security.SimplePrincipal;

public class SerialNumberIssuerDNMapping
implements CertificatePrincipal {
    @Override
    public Principal toPrincipal(X509Certificate[] certs) {
        BigInteger serialNumber = certs[0].getSerialNumber();
        Principal issuer = certs[0].getIssuerDN();
        SimplePrincipal principal = new SimplePrincipal(serialNumber + " " + issuer);
        return principal;
    }

    @Override
    public Principal toPrinicipal(X509Certificate[] certs) {
        return this.toPrincipal(certs);
    }
}

