/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.broker;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.nio.ByteBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessagePersisterV2;
import org.apache.activemq.artemis.protocol.amqp.util.NettyWritable;
import org.apache.activemq.artemis.protocol.amqp.util.TLSEncode;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;

public class AMQPStandardMessage
extends AMQPMessage {
    protected ReadableBuffer data;

    public AMQPStandardMessage(long messageFormat, byte[] data, TypedProperties extraProperties) {
        this(messageFormat, data, extraProperties, null);
    }

    public AMQPStandardMessage(long messageFormat, byte[] data, TypedProperties extraProperties, CoreMessageObjectPools coreMessageObjectPools) {
        this(messageFormat, (ReadableBuffer)ReadableBuffer.ByteBufferReader.wrap((byte[])data), extraProperties, coreMessageObjectPools);
    }

    public AMQPStandardMessage(long messageFormat, ReadableBuffer data, TypedProperties extraProperties, CoreMessageObjectPools coreMessageObjectPools) {
        super(messageFormat, extraProperties, coreMessageObjectPools);
        this.data = data;
        this.ensureMessageDataScanned();
    }

    AMQPStandardMessage(long messageFormat) {
        super(messageFormat);
    }

    @Override
    public Message copy() {
        this.ensureDataIsValid();
        ReadableBuffer view = this.data.duplicate().rewind();
        byte[] newData = new byte[view.remaining()];
        view.get(newData);
        AMQPStandardMessage newEncode = new AMQPStandardMessage(this.messageFormat, newData, this.extraProperties, this.coreMessageObjectPools);
        newEncode.setMessageID(this.getMessageID());
        return newEncode;
    }

    @Override
    public int getEncodeSize() {
        this.ensureDataIsValid();
        return this.data.remaining() - this.encodedDeliveryAnnotationsSize + this.getDeliveryAnnotationsForSendBufferSize();
    }

    @Override
    protected ReadableBuffer getData() {
        return this.data;
    }

    @Override
    public int getMemoryEstimate() {
        if (this.memoryEstimate == -1) {
            this.memoryEstimate = 352 + (this.data != null ? this.data.capacity() : 0);
        }
        return this.memoryEstimate;
    }

    @Override
    public void persist(ActiveMQBuffer targetRecord) {
        this.ensureDataIsValid();
        targetRecord.writeInt(this.internalPersistSize());
        if (this.data.hasArray()) {
            targetRecord.writeBytes(this.data.array(), this.data.arrayOffset(), this.data.remaining());
        } else {
            targetRecord.writeBytes(this.data.byteBuffer());
        }
    }

    public final Message copy(long newID) {
        return this.copy().setMessageID(newID);
    }

    @Override
    public int getPersistSize() {
        this.ensureDataIsValid();
        return 4 + this.internalPersistSize();
    }

    @Override
    public void reloadPersistence(ActiveMQBuffer record, CoreMessageObjectPools pools) {
        int size = record.readInt();
        byte[] recordArray = new byte[size];
        record.readBytes(recordArray);
        this.data = ReadableBuffer.ByteBufferReader.wrap((ByteBuffer)ByteBuffer.wrap(recordArray));
        this.resetMessageData();
        this.modified = false;
        this.messageDataScanned = AMQPMessage.MessageDataScanningStatus.RELOAD_PERSISTENCE.code;
    }

    @Override
    public long getPersistentSize() throws ActiveMQException {
        return this.getEncodeSize();
    }

    @Override
    public Persister<Message> getPersister() {
        return AMQPMessagePersisterV2.getInstance();
    }

    @Override
    public void reencode() {
        this.ensureMessageDataScanned();
        if (this.properties != null && this.address != null) {
            this.properties.setTo(this.address.toString());
        }
        this.encodeMessage();
        this.scanMessageData();
    }

    @Override
    protected synchronized void ensureDataIsValid() {
        if (this.modified) {
            this.encodeMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void encodeMessage() {
        this.modified = false;
        this.messageDataScanned = AMQPMessage.MessageDataScanningStatus.NOT_SCANNED.code;
        int estimated = Math.max(1500, this.data != null ? this.data.capacity() + 1000 : 0);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.heapBuffer(estimated);
        EncoderImpl encoder = TLSEncode.getEncoder();
        try {
            NettyWritable writable = new NettyWritable(buffer);
            encoder.setByteBuffer((WritableBuffer)writable);
            if (this.header != null) {
                encoder.writeObject((Object)this.header);
            }
            if (this.messageAnnotations != null) {
                encoder.writeObject((Object)this.messageAnnotations);
            }
            if (this.properties != null) {
                encoder.writeObject((Object)this.properties);
            }
            if (this.applicationProperties != null) {
                encoder.writeObject((Object)this.applicationProperties);
                if (this.data != null && this.remainingBodyPosition != -1) {
                    writable.put(this.data.position(this.remainingBodyPosition));
                }
            } else if (this.data != null && this.applicationPropertiesPosition != -1) {
                writable.put(this.data.position(this.applicationPropertiesPosition));
            } else if (this.data != null && this.remainingBodyPosition != -1) {
                writable.put(this.data.position(this.remainingBodyPosition));
            }
            byte[] bytes = new byte[buffer.writerIndex()];
            buffer.readBytes(bytes);
            this.data = ReadableBuffer.ByteBufferReader.wrap((ByteBuffer)ByteBuffer.wrap(bytes));
        }
        finally {
            encoder.setByteBuffer((WritableBuffer)null);
            buffer.release();
        }
    }
}

