/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.future.DefaultConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.client.session.SessionFactory;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.keyprovider.AbstractResourceKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.core.CoreModuleProperties;
import org.eclipse.jgit.internal.transport.ssh.OpenSshConfigFile;
import org.eclipse.jgit.internal.transport.sshd.CachingKeyPairProvider;
import org.eclipse.jgit.internal.transport.sshd.JGitClientSession;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.internal.transport.sshd.proxy.HttpClientConnector;
import org.eclipse.jgit.internal.transport.sshd.proxy.Socks5ClientConnector;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.sshd.KeyCache;
import org.eclipse.jgit.transport.sshd.ProxyData;
import org.eclipse.jgit.transport.sshd.ProxyDataFactory;
import org.eclipse.jgit.util.StringUtils;

public class JGitSshClient
extends SshClient {
    static final AttributeRepository.AttributeKey<HostConfigEntry> HOST_CONFIG_ENTRY = new AttributeRepository.AttributeKey();
    static final AttributeRepository.AttributeKey<InetSocketAddress> ORIGINAL_REMOTE_ADDRESS = new AttributeRepository.AttributeKey();
    public static final AttributeRepository.AttributeKey<String> PREFERRED_AUTHENTICATIONS = new AttributeRepository.AttributeKey();
    public static final AttributeRepository.AttributeKey<SshdSocketAddress> LOCAL_FORWARD_ADDRESS = new AttributeRepository.AttributeKey();
    private KeyCache keyCache;
    private CredentialsProvider credentialsProvider;
    private ProxyDataFactory proxyDatabase;

    protected SessionFactory createSessionFactory() {
        return new JGitSessionFactory(this);
    }

    public ConnectFuture connect(HostConfigEntry hostConfig, AttributeRepository context, SocketAddress localAddress) throws IOException {
        ProxyData proxy;
        InetSocketAddress originalAddress;
        if (this.connector == null) {
            throw new IllegalStateException("SshClient not started.");
        }
        Objects.requireNonNull(hostConfig, "No host configuration");
        String originalHost = ValidateUtils.checkNotNullAndNotEmpty((String)hostConfig.getHostName(), (String)"No target host");
        int originalPort = hostConfig.getPort();
        ValidateUtils.checkTrue((originalPort > 0 ? 1 : 0) != 0, (String)"Invalid port: %d", (long)originalPort);
        InetSocketAddress targetAddress = originalAddress = new InetSocketAddress(originalHost, originalPort);
        String userName = hostConfig.getUsername();
        String id = String.valueOf(userName) + '@' + originalAddress;
        AttributeRepository attributes = this.chain(context, (AttributeRepository)this);
        SshdSocketAddress localForward = (SshdSocketAddress)attributes.resolveAttribute(LOCAL_FORWARD_ADDRESS);
        if (localForward != null) {
            targetAddress = new InetSocketAddress(localForward.getHostName(), localForward.getPort());
            id = String.valueOf(id) + '/' + targetAddress.toString();
        }
        DefaultConnectFuture connectFuture = new DefaultConnectFuture((Object)id, null);
        SshFutureListener<IoConnectFuture> listener = this.createConnectCompletionListener((ConnectFuture)connectFuture, userName, originalAddress, hostConfig);
        attributes = this.sessionAttributes(attributes, hostConfig, originalAddress);
        if (localForward == null && (proxy = this.getProxyData(targetAddress)) != null) {
            targetAddress = this.configureProxy(proxy, targetAddress);
            proxy.clearPassword();
        }
        this.connector.connect((SocketAddress)targetAddress, attributes, localAddress).addListener(listener);
        return connectFuture;
    }

    private AttributeRepository chain(AttributeRepository self, AttributeRepository parent) {
        if (self == null) {
            return Objects.requireNonNull(parent);
        }
        if (parent == null || parent == self) {
            return self;
        }
        return new JGitClientSession.ChainingAttributes(self, parent);
    }

    private AttributeRepository sessionAttributes(AttributeRepository parent, HostConfigEntry hostConfig, InetSocketAddress originalAddress) {
        HashMap<Object, Object> data = new HashMap<Object, Object>();
        data.put(HOST_CONFIG_ENTRY, hostConfig);
        data.put(ORIGINAL_REMOTE_ADDRESS, originalAddress);
        data.put(TARGET_SERVER, new SshdSocketAddress(originalAddress));
        String preferredAuths = hostConfig.getProperty("PreferredAuthentications", (String)this.resolveAttribute(PREFERRED_AUTHENTICATIONS));
        if (!StringUtils.isEmptyOrNull((String)preferredAuths)) {
            data.put(JGitClientSession.SessionAttributes.PROPERTIES, Collections.singletonMap(CoreModuleProperties.PREFERRED_AUTHS.getName(), preferredAuths));
        }
        return new JGitClientSession.SessionAttributes(AttributeRepository.ofAttributesMap(data), parent, (PropertyResolver)this);
    }

    private ProxyData getProxyData(InetSocketAddress remoteAddress) {
        ProxyDataFactory factory = this.getProxyDatabase();
        return factory == null ? null : factory.get(remoteAddress);
    }

    private InetSocketAddress configureProxy(ProxyData proxyData, InetSocketAddress remoteAddress) {
        Proxy proxy = proxyData.getProxy();
        if (proxy.type() == Proxy.Type.DIRECT || !(proxy.address() instanceof InetSocketAddress)) {
            return remoteAddress;
        }
        InetSocketAddress address = (InetSocketAddress)proxy.address();
        if (address.isUnresolved()) {
            address = new InetSocketAddress(address.getHostName(), address.getPort());
        }
        switch (proxy.type()) {
            case HTTP: {
                this.setClientProxyConnector(new HttpClientConnector(address, remoteAddress, proxyData.getUser(), proxyData.getPassword()));
                return address;
            }
            case SOCKS: {
                this.setClientProxyConnector(new Socks5ClientConnector(address, remoteAddress, proxyData.getUser(), proxyData.getPassword()));
                return address;
            }
        }
        this.log.warn(MessageFormat.format(SshdText.get().unknownProxyProtocol, proxy.type().name()));
        return remoteAddress;
    }

    private SshFutureListener<IoConnectFuture> createConnectCompletionListener(final ConnectFuture connectFuture, final String username, final InetSocketAddress address, final HostConfigEntry hostConfig) {
        return new SshFutureListener<IoConnectFuture>(){

            public void operationComplete(IoConnectFuture future) {
                if (future.isCanceled()) {
                    connectFuture.cancel();
                    return;
                }
                Throwable t = future.getException();
                if (t != null) {
                    connectFuture.setException(t);
                    return;
                }
                IoSession ioSession = future.getSession();
                try {
                    JGitClientSession session = JGitSshClient.this.createSession(ioSession, username, address, hostConfig);
                    connectFuture.setSession((ClientSession)session);
                }
                catch (RuntimeException e) {
                    connectFuture.setException((Throwable)e);
                    ioSession.close(true);
                }
            }

            public String toString() {
                return "JGitSshClient$ConnectCompletionListener[" + username + '@' + address + ']';
            }
        };
    }

    private JGitClientSession createSession(IoSession ioSession, String username, InetSocketAddress address, HostConfigEntry hostConfig) {
        AbstractSession rawSession = AbstractSession.getSession((IoSession)ioSession);
        if (!(rawSession instanceof JGitClientSession)) {
            throw new IllegalStateException("Wrong session type: " + rawSession.getClass().getCanonicalName());
        }
        JGitClientSession session = (JGitClientSession)rawSession;
        session.setUsername(username);
        session.setConnectAddress(address);
        session.setHostConfigEntry(hostConfig);
        String pubkeyAlgos = hostConfig.getProperty("PubkeyAcceptedAlgorithms");
        if (!StringUtils.isEmptyOrNull((String)pubkeyAlgos)) {
            List<String> signatures = this.getSignatureFactoriesNames();
            if (!(signatures = session.modifyAlgorithmList(signatures, pubkeyAlgos, "PubkeyAcceptedAlgorithms")).isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("PubkeyAcceptedAlgorithms " + signatures);
                }
                session.setSignatureFactoriesNames(signatures);
            } else {
                this.log.warn(MessageFormat.format(SshdText.get().configNoKnownAlgorithms, "PubkeyAcceptedAlgorithms", pubkeyAlgos));
            }
        }
        if (session.getCredentialsProvider() == null) {
            session.setCredentialsProvider(this.getCredentialsProvider());
        }
        int numberOfPasswordPrompts = this.getNumberOfPasswordPrompts(hostConfig);
        CoreModuleProperties.PASSWORD_PROMPTS.set((PropertyResolver)session, (Object)numberOfPasswordPrompts);
        List<Path> identities = hostConfig.getIdentities().stream().map(s -> {
            try {
                return Paths.get(s, new String[0]);
            }
            catch (InvalidPathException e) {
                this.log.warn(MessageFormat.format(SshdText.get().configInvalidPath, "IdentityFile", s), (Throwable)e);
                return null;
            }
        }).filter(p -> p != null && Files.exists(p, new LinkOption[0])).collect(Collectors.toList());
        CachingKeyPairProvider ourConfiguredKeysProvider = new CachingKeyPairProvider(identities, this.keyCache);
        FilePasswordProvider passwordProvider = this.getFilePasswordProvider();
        ourConfiguredKeysProvider.setPasswordFinder(passwordProvider);
        if (hostConfig.isIdentitiesOnly()) {
            session.setKeyIdentityProvider((KeyIdentityProvider)ourConfiguredKeysProvider);
        } else {
            KeyIdentityProvider defaultKeysProvider = this.getKeyIdentityProvider();
            if (defaultKeysProvider instanceof AbstractResourceKeyPairProvider) {
                ((AbstractResourceKeyPairProvider)defaultKeysProvider).setPasswordFinder(passwordProvider);
            }
            CombinedKeyIdentityProvider combinedProvider = new CombinedKeyIdentityProvider(new KeyIdentityProvider[]{ourConfiguredKeysProvider, defaultKeysProvider});
            session.setKeyIdentityProvider(combinedProvider);
        }
        return session;
    }

    private int getNumberOfPasswordPrompts(HostConfigEntry hostConfig) {
        String prompts = hostConfig.getProperty("NumberOfPasswordPrompts");
        if (prompts != null) {
            int value = OpenSshConfigFile.positive((String)(prompts = prompts.trim()));
            if (value > 0) {
                return value;
            }
            this.log.warn(MessageFormat.format(SshdText.get().configInvalidPositive, "NumberOfPasswordPrompts", prompts));
        }
        return (Integer)CoreModuleProperties.PASSWORD_PROMPTS.getRequiredDefault();
    }

    public void setKeyCache(KeyCache cache) {
        this.keyCache = cache;
    }

    public void setProxyDatabase(ProxyDataFactory factory) {
        this.proxyDatabase = factory;
    }

    protected ProxyDataFactory getProxyDatabase() {
        return this.proxyDatabase;
    }

    public void setCredentialsProvider(CredentialsProvider provider) {
        this.credentialsProvider = provider;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    private static class CombinedKeyIdentityProvider
    implements KeyIdentityProvider {
        private final List<KeyIdentityProvider> providers;

        public CombinedKeyIdentityProvider(KeyIdentityProvider ... providers) {
            this(Arrays.stream(providers).filter(Objects::nonNull).collect(Collectors.toList()));
        }

        public CombinedKeyIdentityProvider(List<KeyIdentityProvider> providers) {
            this.providers = providers;
        }

        public Iterable<KeyPair> loadKeys(final SessionContext context) {
            return () -> new Iterator<KeyPair>(){
                private Iterator<KeyIdentityProvider> factories;
                private Iterator<KeyPair> current;
                private Boolean hasElement;
                {
                    this.factories = combinedKeyIdentityProvider.providers.iterator();
                }

                /*
                 * Unable to fully structure code
                 */
                @Override
                public boolean hasNext() {
                    if (this.hasElement == null) ** GOTO lbl12
                    return this.hasElement;
lbl-1000:
                    // 1 sources

                    {
                        if (this.factories.hasNext()) {
                            try {
                                this.current = this.factories.next().loadKeys(context).iterator();
                            }
                            catch (IOException | GeneralSecurityException e) {
                                throw new RuntimeException(e);
                            }
                        } else {
                            this.current = null;
                            this.hasElement = Boolean.FALSE;
                            return false;
                        }
lbl12:
                        // 2 sources

                        ** while (this.current == null || !this.current.hasNext())
                    }
lbl13:
                    // 1 sources

                    this.hasElement = Boolean.TRUE;
                    return true;
                }

                @Override
                public KeyPair next() {
                    KeyPair result;
                    if (this.hasElement == null && !this.hasNext() || !this.hasElement.booleanValue()) {
                        throw new NoSuchElementException();
                    }
                    this.hasElement = null;
                    try {
                        result = this.current.next();
                    }
                    catch (NoSuchElementException e) {
                        result = null;
                    }
                    return result;
                }
            };
        }
    }

    private static class JGitSessionFactory
    extends SessionFactory {
        public JGitSessionFactory(JGitSshClient client) {
            super((ClientFactoryManager)client);
        }

        protected ClientSessionImpl doCreateSession(IoSession ioSession) throws Exception {
            return new JGitClientSession(this.getClient(), ioSession);
        }
    }
}

