/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security.jacc;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import org.jboss.as.ee.security.JaccService;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.EmptyRoleSemanticType;
import org.jboss.metadata.web.spec.HttpMethodConstraintMetaData;
import org.jboss.metadata.web.spec.SecurityConstraintMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.ServletSecurityMetaData;
import org.jboss.metadata.web.spec.UserDataConstraintMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionsMetaData;

public class WarJACCService
extends JaccService<WarMetaData> {
    private static final int PREFIX = 1;
    private static final int EXTENSION = 2;
    private static final int DEFAULT = 3;
    private static final int EXACT = 4;
    private static final String ANY_AUTHENTICATED_USER_ROLE = "**";

    public WarJACCService(String contextId, WarMetaData metaData, Boolean standalone) {
        super(contextId, (Object)metaData, standalone);
    }

    public void createPermissions(WarMetaData metaData, PolicyConfiguration pc) throws PolicyContextException {
        List authRoles;
        HashSet<String> mappedRoles;
        Object info;
        JBossWebMetaData jbossWebMetaData = metaData.getMergedJBossWebMetaData();
        HashMap<String, PatternInfo> patternMap = WarJACCService.qualifyURLPatterns(jbossWebMetaData);
        List secConstraints = jbossWebMetaData.getSecurityConstraints();
        if (secConstraints != null) {
            for (SecurityConstraintMetaData secConstraint : secConstraints) {
                List urlPatterns;
                ArrayList<String> httpMethods;
                WebResourceCollectionsMetaData resourceCollectionsMetaData = secConstraint.getResourceCollections();
                UserDataConstraintMetaData userDataConstraintMetaData = secConstraint.getUserDataConstraint();
                if (resourceCollectionsMetaData == null) continue;
                if (secConstraint.isExcluded() || secConstraint.isUnchecked()) {
                    for (WebResourceCollectionMetaData resourceCollectionMetaData : resourceCollectionsMetaData) {
                        httpMethods = new ArrayList<String>(resourceCollectionMetaData.getHttpMethods());
                        List ommisions = resourceCollectionMetaData.getHttpMethodOmissions();
                        if (httpMethods.isEmpty() && !ommisions.isEmpty()) {
                            httpMethods.addAll(WebResourceCollectionMetaData.ALL_HTTP_METHODS);
                            httpMethods.removeAll(ommisions);
                        }
                        urlPatterns = resourceCollectionMetaData.getUrlPatterns();
                        for (String urlPattern : urlPatterns) {
                            info = patternMap.get(urlPattern);
                            ((PatternInfo)info).descriptor = true;
                            if (secConstraint.isExcluded()) {
                                ((PatternInfo)info).addExcludedMethods(httpMethods);
                            }
                            if (secConstraint.isUnchecked() && httpMethods.isEmpty()) {
                                ((PatternInfo)info).isMissingAuthConstraint = true;
                                continue;
                            }
                            ((PatternInfo)info).missingAuthConstraintMethods.addAll(httpMethods);
                        }
                    }
                    continue;
                }
                for (WebResourceCollectionMetaData resourceCollectionMetaData : resourceCollectionsMetaData) {
                    httpMethods = new ArrayList(resourceCollectionMetaData.getHttpMethods());
                    Iterator methodOmissions = resourceCollectionMetaData.getHttpMethodOmissions();
                    if (httpMethods.isEmpty() && !methodOmissions.isEmpty()) {
                        httpMethods.addAll(WebResourceCollectionMetaData.ALL_HTTP_METHODS);
                        httpMethods.removeAll((Collection<?>)((Object)methodOmissions));
                    }
                    urlPatterns = resourceCollectionMetaData.getUrlPatterns();
                    for (String urlPattern : urlPatterns) {
                        info = patternMap.get(urlPattern);
                        ((PatternInfo)info).descriptor = true;
                        mappedRoles = new HashSet<String>();
                        secConstraint.getAuthConstraint().getRoleNames();
                        authRoles = secConstraint.getAuthConstraint().getRoleNames();
                        for (String role : authRoles) {
                            if ("*".equals(role)) {
                                mappedRoles.addAll(jbossWebMetaData.getSecurityRoleNames());
                                continue;
                            }
                            mappedRoles.add(role);
                        }
                        ((PatternInfo)info).addRoles(mappedRoles, httpMethods);
                        if (userDataConstraintMetaData == null || userDataConstraintMetaData.getTransportGuarantee() == null) continue;
                        ((PatternInfo)info).addTransport(userDataConstraintMetaData.getTransportGuarantee().name(), httpMethods);
                    }
                }
            }
        }
        JBossServletsMetaData servlets = jbossWebMetaData.getServlets();
        List mappings = jbossWebMetaData.getServletMappings();
        if (servlets != null && mappings != null) {
            HashMap servletMappingMap = new HashMap();
            for (ServletMappingMetaData mapping : mappings) {
                ArrayList list = (ArrayList)servletMappingMap.get(mapping.getServletName());
                if (list == null) {
                    list = new ArrayList();
                    servletMappingMap.put(mapping.getServletName(), list);
                }
                list.addAll(mapping.getUrlPatterns());
            }
            if (!jbossWebMetaData.isMetadataComplete()) {
                for (JBossServletMetaData servlet : servlets) {
                    PatternInfo info2;
                    List servletMappings;
                    ServletSecurityMetaData security = servlet.getServletSecurity();
                    if (security == null || (servletMappings = (List)servletMappingMap.get(servlet.getServletName())) == null) continue;
                    if (security.getHttpMethodConstraints() != null) {
                        for (HttpMethodConstraintMetaData s : security.getHttpMethodConstraints()) {
                            if (s.getRolesAllowed() == null || s.getRolesAllowed().isEmpty()) {
                                for (String urlPattern : servletMappings) {
                                    info = patternMap.get(urlPattern);
                                    if (((PatternInfo)info).descriptor) continue;
                                    if (s.getEmptyRoleSemantic() == null || s.getEmptyRoleSemantic() == EmptyRoleSemanticType.PERMIT) {
                                        ((PatternInfo)info).missingAuthConstraintMethods.add(s.getMethod());
                                    } else {
                                        ((PatternInfo)info).addExcludedMethods(Collections.singletonList(s.getMethod()));
                                    }
                                    if (s.getTransportGuarantee() == null) continue;
                                    ((PatternInfo)info).addTransport(s.getTransportGuarantee().name(), Collections.singletonList(s.getMethod()));
                                }
                                continue;
                            }
                            for (String urlPattern : servletMappings) {
                                info = patternMap.get(urlPattern);
                                if (((PatternInfo)info).descriptor) continue;
                                mappedRoles = new HashSet();
                                authRoles = s.getRolesAllowed();
                                for (String role : authRoles) {
                                    if ("*".equals(role)) {
                                        mappedRoles.addAll(jbossWebMetaData.getSecurityRoleNames());
                                        continue;
                                    }
                                    mappedRoles.add(role);
                                }
                                ((PatternInfo)info).addRoles(mappedRoles, Collections.singletonList(s.getMethod()));
                                if (s.getTransportGuarantee() == null) continue;
                                ((PatternInfo)info).addTransport(s.getTransportGuarantee().name(), Collections.singletonList(s.getMethod()));
                            }
                        }
                    }
                    if (security.getRolesAllowed() == null || security.getRolesAllowed().isEmpty()) {
                        for (String urlPattern : servletMappings) {
                            info2 = patternMap.get(urlPattern);
                            if (info2.descriptor) continue;
                            if (security.getEmptyRoleSemantic() == null || security.getEmptyRoleSemantic() == EmptyRoleSemanticType.PERMIT) {
                                info2.isMissingAuthConstraint = true;
                            } else {
                                HashSet methods = new HashSet(WebResourceCollectionMetaData.ALL_HTTP_METHODS);
                                if (security.getHttpMethodConstraints() != null) {
                                    for (HttpMethodConstraintMetaData method : security.getHttpMethodConstraints()) {
                                        methods.remove(method.getMethod());
                                    }
                                }
                                info2.addExcludedMethods(new ArrayList<String>(methods));
                            }
                            if (security.getTransportGuarantee() == null) continue;
                            info2.addTransport(security.getTransportGuarantee().name(), Collections.emptyList());
                        }
                        continue;
                    }
                    for (String urlPattern : servletMappings) {
                        HttpMethodConstraintMetaData method;
                        info2 = patternMap.get(urlPattern);
                        if (info2.descriptor) continue;
                        HashSet<String> mappedRoles2 = new HashSet<String>();
                        List authRoles2 = security.getRolesAllowed();
                        method = authRoles2.iterator();
                        while (method.hasNext()) {
                            String role = (String)method.next();
                            if ("*".equals(role)) {
                                mappedRoles2.addAll(jbossWebMetaData.getSecurityRoleNames());
                                continue;
                            }
                            mappedRoles2.add(role);
                        }
                        info2.addRoles(mappedRoles2, Collections.emptyList());
                        if (security.getTransportGuarantee() == null) continue;
                        info2.addTransport(security.getTransportGuarantee().name(), Collections.emptyList());
                    }
                }
            }
        }
        for (PatternInfo info3 : patternMap.values()) {
            String qurl = info3.getQualifiedPattern();
            if (info3.isOverridden) continue;
            String[] httpMethods = info3.getExcludedMethods();
            if (httpMethods != null) {
                WebResourcePermission wrp = new WebResourcePermission(qurl, httpMethods);
                WebUserDataPermission wudp = new WebUserDataPermission(qurl, httpMethods, null);
                pc.addToExcludedPolicy((Permission)wrp);
                pc.addToExcludedPolicy((Permission)wudp);
            }
            Iterator<Map.Entry<String, Set<String>>> roles = info3.getRoleMethods();
            HashSet<String> seenMethods = new HashSet<String>();
            while (roles.hasNext()) {
                Map.Entry<String, Set<String>> roleMethods = roles.next();
                String role = roleMethods.getKey();
                Set<String> methods = roleMethods.getValue();
                seenMethods.addAll(methods);
                httpMethods = methods.toArray(new String[methods.size()]);
                pc.addToRole(role, (Permission)new WebResourcePermission(qurl, httpMethods));
            }
            int NUMBER_OF_HTTP_METHODS = 7;
            if (jbossWebMetaData.getDenyUncoveredHttpMethods() == null && seenMethods.size() != 7) {
                WebResourcePermission wrpUnchecked = seenMethods.size() == 0 ? new WebResourcePermission(qurl, (String)null) : new WebResourcePermission(qurl, "!" + WarJACCService.getCommaSeparatedString(seenMethods.toArray(new String[seenMethods.size()])));
                pc.addToUncheckedPolicy((Permission)wrpUnchecked);
            }
            if (jbossWebMetaData.getDenyUncoveredHttpMethods() == null) {
                String[] missingHttpMethods = info3.getMissingMethods();
                int length = missingHttpMethods.length;
                roles = info3.getRoleMethods();
                if (length > 0 && !roles.hasNext()) {
                    WebResourcePermission wrp = new WebResourcePermission(qurl, missingHttpMethods);
                    pc.addToUncheckedPolicy((Permission)wrp);
                } else if (!roles.hasNext()) {
                    pc.addToUncheckedPolicy((Permission)new WebResourcePermission(qurl, (String)null));
                }
                if (info3.isMissingAuthConstraint) {
                    pc.addToUncheckedPolicy((Permission)new WebResourcePermission(qurl, (String)null));
                } else if (!info3.allMethods.containsAll(WebResourceCollectionMetaData.ALL_HTTP_METHODS)) {
                    ArrayList methods = new ArrayList(WebResourceCollectionMetaData.ALL_HTTP_METHODS);
                    methods.removeAll(info3.allMethods);
                    pc.addToUncheckedPolicy((Permission)new WebResourcePermission(qurl, methods.toArray(new String[methods.size()])));
                }
                if (!info3.missingAuthConstraintMethods.isEmpty()) {
                    pc.addToUncheckedPolicy((Permission)new WebResourcePermission(qurl, info3.missingAuthConstraintMethods.toArray(new String[info3.missingAuthConstraintMethods.size()])));
                }
            }
            Iterator<Map.Entry<String, Set<String>>> transportConstraints = info3.getTransportMethods();
            while (transportConstraints.hasNext()) {
                Map.Entry<String, Set<String>> transportMethods = transportConstraints.next();
                String transport = transportMethods.getKey();
                Set<String> methods = transportMethods.getValue();
                httpMethods = new String[methods.size()];
                methods.toArray(httpMethods);
                WebUserDataPermission wudp = new WebUserDataPermission(qurl, httpMethods, transport);
                pc.addToUncheckedPolicy((Permission)wudp);
                if ("NONE".equals(transport)) {
                    WebUserDataPermission wudp1 = new WebUserDataPermission(qurl, null);
                    pc.addToUncheckedPolicy((Permission)wudp1);
                    continue;
                }
                WebUserDataPermission wudpNonNull = new WebUserDataPermission(qurl, "!" + WarJACCService.getCommaSeparatedString(httpMethods));
                pc.addToUncheckedPolicy((Permission)wudpNonNull);
            }
        }
        Set declaredRoles = jbossWebMetaData.getSecurityRoleNames();
        declaredRoles.add(ANY_AUTHENTICATED_USER_ROLE);
        JBossServletsMetaData servletsMetaData = jbossWebMetaData.getServlets();
        for (JBossServletMetaData servletMetaData : servletsMetaData) {
            HashSet unrefRoles = new HashSet(declaredRoles);
            String servletName = servletMetaData.getName();
            SecurityRoleRefsMetaData roleRefsMetaData = servletMetaData.getSecurityRoleRefs();
            if (roleRefsMetaData != null) {
                for (SecurityRoleRefMetaData roleRefMetaData : roleRefsMetaData) {
                    String roleRef = roleRefMetaData.getRoleLink();
                    String roleName = roleRefMetaData.getRoleName();
                    WebRoleRefPermission wrrp = new WebRoleRefPermission(servletName, roleName);
                    pc.addToRole(roleRef, (Permission)wrrp);
                    unrefRoles.remove(roleName);
                }
            }
            for (String unrefRole : unrefRoles) {
                WebRoleRefPermission unrefP = new WebRoleRefPermission(servletName, unrefRole);
                pc.addToRole(unrefRole, (Permission)unrefP);
            }
        }
        for (String role : declaredRoles) {
            WebRoleRefPermission wrrep = new WebRoleRefPermission("", role);
            pc.addToRole(role, (Permission)wrrep);
        }
    }

    static String getCommaSeparatedString(String[] str) {
        int len = str.length;
        Arrays.sort(str);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(str[i]);
        }
        return buf.toString();
    }

    static int getPatternType(String urlPattern) {
        int type = 4;
        if (urlPattern.startsWith("*.")) {
            type = 2;
        } else if (urlPattern.startsWith("/") && urlPattern.endsWith("/*")) {
            type = 1;
        } else if (urlPattern.equals("/")) {
            type = 3;
        }
        return type;
    }

    static HashMap<String, PatternInfo> qualifyURLPatterns(JBossWebMetaData metaData) {
        ArrayList<PatternInfo> prefixList = new ArrayList<PatternInfo>();
        ArrayList<PatternInfo> extensionList = new ArrayList<PatternInfo>();
        ArrayList<PatternInfo> exactList = new ArrayList<PatternInfo>();
        HashMap<String, PatternInfo> patternMap = new HashMap<String, PatternInfo>();
        PatternInfo defaultInfo = null;
        List constraints = metaData.getSecurityConstraints();
        if (constraints != null) {
            for (SecurityConstraintMetaData constraint : constraints) {
                WebResourceCollectionsMetaData resourceCollectionsMetaData = constraint.getResourceCollections();
                if (resourceCollectionsMetaData == null) continue;
                for (WebResourceCollectionMetaData resourceCollectionMetaData : resourceCollectionsMetaData) {
                    List urlPatterns = resourceCollectionMetaData.getUrlPatterns();
                    for (String url : urlPatterns) {
                        int type = WarJACCService.getPatternType(url);
                        PatternInfo info = patternMap.get(url);
                        if (info != null) continue;
                        info = new PatternInfo(url, type);
                        patternMap.put(url, info);
                        switch (type) {
                            case 1: {
                                prefixList.add(info);
                                break;
                            }
                            case 2: {
                                extensionList.add(info);
                                break;
                            }
                            case 4: {
                                exactList.add(info);
                                break;
                            }
                            case 3: {
                                defaultInfo = info;
                            }
                        }
                    }
                }
            }
        }
        JBossServletsMetaData servlets = metaData.getServlets();
        List mappings = metaData.getServletMappings();
        if (!metaData.isMetadataComplete() && servlets != null && mappings != null) {
            HashMap servletMappingMap = new HashMap();
            for (ServletMappingMetaData mapping : mappings) {
                ArrayList list = (ArrayList)servletMappingMap.get(mapping.getServletName());
                if (list == null) {
                    list = new ArrayList();
                    servletMappingMap.put(mapping.getServletName(), list);
                }
                list.addAll(mapping.getUrlPatterns());
            }
            for (JBossServletMetaData servlet : servlets) {
                List servletMappings;
                ServletSecurityMetaData security = servlet.getServletSecurity();
                if (security == null || (servletMappings = (List)servletMappingMap.get(servlet.getServletName())) == null) continue;
                for (String url : servletMappings) {
                    int type = WarJACCService.getPatternType(url);
                    PatternInfo info = patternMap.get(url);
                    if (info != null) continue;
                    info = new PatternInfo(url, type);
                    patternMap.put(url, info);
                    switch (type) {
                        case 1: {
                            prefixList.add(info);
                            break;
                        }
                        case 2: {
                            extensionList.add(info);
                            break;
                        }
                        case 4: {
                            exactList.add(info);
                            break;
                        }
                        case 3: {
                            defaultInfo = info;
                        }
                    }
                }
            }
        }
        for (int i = 0; i < prefixList.size(); ++i) {
            PatternInfo info = (PatternInfo)prefixList.get(i);
            for (int j = 0; j < prefixList.size(); ++j) {
                PatternInfo other;
                if (i == j || !info.matches(other = (PatternInfo)prefixList.get(j))) continue;
                info.addQualifier(other);
            }
            for (PatternInfo other : exactList) {
                if (!info.matches(other)) continue;
                info.addQualifier(other);
            }
        }
        for (PatternInfo info : extensionList) {
            for (PatternInfo other : prefixList) {
                info.addQualifier(other);
            }
            for (PatternInfo other : exactList) {
                if (!info.isExtensionFor(other)) continue;
                info.addQualifier(other);
            }
        }
        if (defaultInfo == null) {
            defaultInfo = new PatternInfo("/", 3);
            patternMap.put("/", defaultInfo);
        }
        for (PatternInfo info : patternMap.values()) {
            if (info == defaultInfo) continue;
            defaultInfo.addQualifier(info);
        }
        return patternMap;
    }

    static class PatternInfo {
        static final HashMap<String, Set<String>> ALL_TRANSPORTS = new HashMap();
        String pattern;
        String qpattern;
        ArrayList<PatternInfo> qualifiers = new ArrayList();
        int type;
        HashSet<String> excludedMethods;
        HashMap<String, Set<String>> roles;
        HashMap<String, Set<String>> transports;
        HashSet<String> allMethods = new HashSet();
        boolean isOverridden;
        boolean isMissingAuthConstraint;
        Set<String> missingAuthConstraintMethods = new HashSet<String>();
        boolean descriptor = false;

        PatternInfo(String pattern, int type) {
            this.pattern = pattern;
            this.type = type;
        }

        void addExcludedMethods(List<String> httpMethods) {
            Collection<String> methods = httpMethods;
            if (methods.size() == 0) {
                methods = WebResourceCollectionMetaData.ALL_HTTP_METHODS;
            }
            if (this.excludedMethods == null) {
                this.excludedMethods = new HashSet();
            }
            this.excludedMethods.addAll(methods);
            this.allMethods.addAll(methods);
        }

        public String[] getExcludedMethods() {
            String[] httpMethods = null;
            if (this.excludedMethods != null) {
                httpMethods = new String[this.excludedMethods.size()];
                this.excludedMethods.toArray(httpMethods);
            }
            return httpMethods;
        }

        public void addRoles(HashSet<String> mappedRoles, List<String> httpMethods) {
            Collection<String> methods = httpMethods;
            if (methods.size() == 0) {
                methods = WebResourceCollectionMetaData.ALL_HTTP_METHODS;
            }
            this.allMethods.addAll(methods);
            if (this.roles == null) {
                this.roles = new HashMap();
            }
            for (String role : mappedRoles) {
                Set<String> roleMethods = this.roles.get(role);
                if (roleMethods == null) {
                    roleMethods = new HashSet<String>();
                    this.roles.put(role, roleMethods);
                }
                roleMethods.addAll(methods);
            }
        }

        public Iterator<Map.Entry<String, Set<String>>> getRoleMethods() {
            HashMap<String, Set<String>> tmp = this.roles;
            if (tmp == null) {
                tmp = new HashMap(0);
            }
            return tmp.entrySet().iterator();
        }

        void addTransport(String transport, List<String> httpMethods) {
            Set<String> transportMethods;
            Collection<String> methods = httpMethods;
            if (methods.size() == 0) {
                methods = WebResourceCollectionMetaData.ALL_HTTP_METHODS;
            }
            if (this.transports == null) {
                this.transports = new HashMap();
            }
            if ((transportMethods = this.transports.get(transport)) == null) {
                transportMethods = new HashSet<String>();
                this.transports.put(transport, transportMethods);
            }
            transportMethods.addAll(methods);
        }

        public Iterator<Map.Entry<String, Set<String>>> getTransportMethods() {
            HashMap<String, Set<String>> tmp = this.transports;
            if (tmp == null) {
                tmp = ALL_TRANSPORTS;
            }
            return tmp.entrySet().iterator();
        }

        public String[] getMissingMethods() {
            String[] httpMethods = new String[]{};
            httpMethods = this.allMethods.size() == 0 ? WebResourceCollectionMetaData.ALL_HTTP_METHOD_NAMES : WebResourceCollectionMetaData.getMissingHttpMethods(this.allMethods);
            return httpMethods;
        }

        void addQualifier(PatternInfo info) {
            if (!this.qualifiers.contains(info)) {
                if (info.type == 1 && info.matches(this)) {
                    this.isOverridden = true;
                }
                this.qualifiers.add(info);
            }
        }

        public String getQualifiedPattern() {
            if (this.qpattern == null) {
                StringBuilder tmp = new StringBuilder(this.pattern);
                for (int n = 0; n < this.qualifiers.size(); ++n) {
                    tmp.append(':');
                    PatternInfo info = this.qualifiers.get(n);
                    tmp.append(info.pattern);
                }
                this.qpattern = tmp.toString();
            }
            return this.qpattern;
        }

        public int hashCode() {
            return this.pattern.hashCode();
        }

        public boolean equals(Object obj) {
            PatternInfo pi = (PatternInfo)obj;
            return this.pattern.equals(pi.pattern);
        }

        public boolean matches(PatternInfo other) {
            if ("/*".equals(this.pattern)) {
                return true;
            }
            int matchLength = this.pattern.length() - 1;
            boolean matches = this.pattern.regionMatches(0, other.pattern, 0, matchLength);
            return matches;
        }

        public boolean isExtensionFor(PatternInfo other) {
            int offset = other.pattern.lastIndexOf(46);
            int length = this.pattern.length() - 1;
            boolean isExtensionFor = false;
            if (offset > 0) {
                isExtensionFor = this.pattern.regionMatches(1, other.pattern, offset, length);
            }
            return isExtensionFor;
        }

        public String toString() {
            StringBuilder tmp = new StringBuilder("PatternInfo[");
            tmp.append("pattern=");
            tmp.append(this.pattern);
            tmp.append(",type=");
            tmp.append(this.type);
            tmp.append(",isOverridden=");
            tmp.append(this.isOverridden);
            tmp.append(",qualifiers=");
            tmp.append(this.qualifiers);
            tmp.append("]");
            return tmp.toString();
        }

        static {
            ALL_TRANSPORTS.put("NONE", WebResourceCollectionMetaData.ALL_HTTP_METHODS);
        }
    }
}

