/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.logging;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.logging.LoggingUtils;
import org.apache.sshd.common.util.logging.SimplifiedLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoggingBean {
    protected final Logger log;
    private final AtomicReference<SimplifiedLog> simplifiedLog = new AtomicReference();

    protected AbstractLoggingBean() {
        this("");
    }

    protected AbstractLoggingBean(String discriminator) {
        String name = this.getClass().getName();
        if (GenericUtils.isNotEmpty(discriminator)) {
            name = name + "[" + discriminator + "]";
        }
        this.log = LoggerFactory.getLogger(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SimplifiedLog getSimplifiedLogger() {
        SimplifiedLog logger2;
        AtomicReference<SimplifiedLog> atomicReference = this.simplifiedLog;
        synchronized (atomicReference) {
            logger2 = this.simplifiedLog.get();
            if (logger2 == null) {
                logger2 = LoggingUtils.wrap(this.log);
            }
        }
        return logger2;
    }

    protected void debug(String message, Object o1, Object o2, Throwable t) {
        LoggingUtils.debug(this.log, message, o1, o2, t);
    }

    protected void debug(String message, Object o1, Object o2, Object o3, Throwable t) {
        LoggingUtils.debug(this.log, message, o1, o2, o3, t);
    }

    protected void debug(String message, Object o1, Object o2, Object o3, Object o4, Throwable t) {
        LoggingUtils.debug(this.log, message, o1, o2, o3, o4, t);
    }

    protected void debug(String message, Object o1, Object o2, Object o3, Object o4, Object o5, Throwable t) {
        LoggingUtils.debug(this.log, message, o1, o2, o3, o4, o5, t);
    }

    protected void debug(String message, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Throwable t) {
        LoggingUtils.debug(this.log, message, o1, o2, o3, o4, o5, o6, t);
    }

    protected void info(String message, Object o1, Object o2, Throwable t) {
        LoggingUtils.info(this.log, message, o1, o2, t);
    }

    protected void info(String message, Object o1, Object o2, Object o3, Throwable t) {
        LoggingUtils.info(this.log, message, o1, o2, o3, t);
    }

    protected void warn(String message, Object o1, Object o2, Throwable t) {
        LoggingUtils.warn(this.log, message, o1, o2, t);
    }

    protected void warn(String message, Object o1, Object o2, Object o3, Throwable t) {
        LoggingUtils.warn(this.log, message, o1, o2, o3, t);
    }

    protected void warn(String message, Object o1, Object o2, Object o3, Object o4, Throwable t) {
        LoggingUtils.warn(this.log, message, o1, o2, o3, o4, t);
    }

    protected void warn(String message, Object o1, Object o2, Object o3, Object o4, Object o5, Throwable t) {
        LoggingUtils.warn(this.log, message, o1, o2, o3, o4, o5, t);
    }

    protected void warn(String message, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Throwable t) {
        LoggingUtils.warn(this.log, message, o1, o2, o3, o4, o5, o6, t);
    }

    protected void warn(String message, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Throwable t) {
        LoggingUtils.warn(this.log, message, o1, o2, o3, o4, o5, o6, o7, t);
    }

    protected void warn(String message, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Throwable t) {
        LoggingUtils.warn(this.log, message, o1, o2, o3, o4, o5, o6, o7, o8, t);
    }

    protected void warn(String message, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9, Throwable t) {
        LoggingUtils.warn(this.log, message, o1, o2, o3, o4, o5, o6, o7, o8, o9, t);
    }

    protected void error(String message, Object o1, Object o2, Throwable t) {
        LoggingUtils.error(this.log, message, o1, o2, t);
    }

    protected void error(String message, Object o1, Object o2, Object o3, Throwable t) {
        LoggingUtils.error(this.log, message, o1, o2, o3, t);
    }

    protected void error(String message, Object o1, Object o2, Object o3, Object o4, Throwable t) {
        LoggingUtils.error(this.log, message, o1, o2, o3, o4, t);
    }

    protected void error(String message, Object o1, Object o2, Object o3, Object o4, Object o5, Throwable t) {
        LoggingUtils.error(this.log, message, o1, o2, o3, o4, o5, t);
    }

    protected void error(String message, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Throwable t) {
        LoggingUtils.error(this.log, message, o1, o2, o3, o4, o5, o6, t);
    }
}

