/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive.publisher.impl.commands.batch;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.IntSet;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.reactive.publisher.impl.DeliveryGuarantee;
import org.infinispan.reactive.publisher.impl.PublisherHandler;
import org.infinispan.util.ByteString;
import org.reactivestreams.Publisher;

public class InitialPublisherCommand<K, I, R>
extends BaseRpcCommand
implements TopologyAffectedCommand {
    public static final byte COMMAND_ID = 18;
    private String requestId;
    private DeliveryGuarantee deliveryGuarantee;
    private int batchSize;
    private IntSet segments;
    private Set<K> keys;
    private Set<K> excludedKeys;
    private boolean includeLoader;
    private boolean entryStream;
    private boolean trackKeys;
    private Function<? super Publisher<I>, ? extends Publisher<R>> transformer;
    private int topologyId = -1;

    private InitialPublisherCommand() {
        super(null);
    }

    public InitialPublisherCommand(ByteString cacheName) {
        super(cacheName);
    }

    public InitialPublisherCommand(ByteString cacheName, String requestId, DeliveryGuarantee deliveryGuarantee, int batchSize, IntSet segments, Set<K> keys, Set<K> excludedKeys, boolean includeLoader, boolean entryStream, boolean trackKeys, Function<? super Publisher<I>, ? extends Publisher<R>> transformer) {
        super(cacheName);
        this.requestId = requestId;
        this.deliveryGuarantee = deliveryGuarantee;
        this.batchSize = batchSize;
        this.segments = segments;
        this.keys = keys;
        this.excludedKeys = excludedKeys;
        this.includeLoader = includeLoader;
        this.entryStream = entryStream;
        this.trackKeys = trackKeys;
        this.transformer = transformer;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public DeliveryGuarantee getDeliveryGuarantee() {
        return this.deliveryGuarantee;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public IntSet getSegments() {
        return this.segments;
    }

    public Set<K> getKeys() {
        return this.keys;
    }

    public Set<K> getExcludedKeys() {
        return this.excludedKeys;
    }

    public boolean isIncludeLoader() {
        return this.includeLoader;
    }

    public boolean isEntryStream() {
        return this.entryStream;
    }

    public boolean isTrackKeys() {
        return this.trackKeys;
    }

    public Function<? super Publisher<I>, ? extends Publisher<R>> getTransformer() {
        return this.transformer;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) throws Throwable {
        if (this.transformer instanceof InjectableComponent) {
            ((InjectableComponent)((Object)this.transformer)).inject(componentRegistry);
        }
        PublisherHandler publisherHandler = componentRegistry.getPublisherHandler().running();
        return publisherHandler.register(this);
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @Override
    public byte getCommandId() {
        return 18;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeUTF(this.requestId);
        MarshallUtil.marshallEnum((Enum)this.deliveryGuarantee, (ObjectOutput)output);
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)this.batchSize);
        output.writeObject(this.segments);
        MarshallUtil.marshallCollection(this.keys, (ObjectOutput)output);
        MarshallUtil.marshallCollection(this.excludedKeys, (ObjectOutput)output);
        output.writeBoolean(this.includeLoader);
        output.writeBoolean(this.entryStream);
        output.writeBoolean(this.trackKeys);
        output.writeObject(this.transformer);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.requestId = input.readUTF();
        this.deliveryGuarantee = (DeliveryGuarantee)MarshallUtil.unmarshallEnum((ObjectInput)input, DeliveryGuarantee::valueOf);
        this.batchSize = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        this.segments = (IntSet)input.readObject();
        this.keys = (Set)MarshallUtil.unmarshallCollectionUnbounded((ObjectInput)input, HashSet::new);
        this.excludedKeys = (Set)MarshallUtil.unmarshallCollectionUnbounded((ObjectInput)input, HashSet::new);
        this.includeLoader = input.readBoolean();
        this.entryStream = input.readBoolean();
        this.trackKeys = input.readBoolean();
        this.transformer = (Function)input.readObject();
    }
}

