/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.AnyField;
import org.wildfly.clustering.marshalling.protostream.FieldMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.ScalarMarshaller;

public class TypedObjectMarshaller
implements FieldMarshaller<Object> {
    private final ScalarMarshaller<Class<?>> type;

    public TypedObjectMarshaller(ScalarMarshaller<Class<?>> typeValue) {
        this.type = typeValue;
    }

    @Override
    public Object readFrom(ProtoStreamReader reader) throws IOException {
        Class targetClass = (Class)this.type.readFrom(reader);
        Object result = null;
        while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            if (index == AnyField.ANY.getIndex()) {
                result = reader.readObject(targetClass);
                continue;
            }
            reader.skipField(tag);
        }
        return result;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, Object value) throws IOException {
        this.type.writeTo(writer, value.getClass());
        writer.writeObject(AnyField.ANY.getIndex(), value);
    }

    @Override
    public Class<? extends Object> getJavaClass() {
        return Object.class;
    }

    @Override
    public WireType getWireType() {
        return this.type.getWireType();
    }
}

