/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.time;

import java.io.IOException;
import java.time.LocalDate;
import java.time.Year;
import org.wildfly.clustering.marshalling.protostream.FieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public enum YearMarshaller implements FieldSetMarshaller<Year, Year>
{
    INSTANCE;

    private static final int POST_EPOCH_YEAR = 0;
    private static final int PRE_EPOCH_YEAR = 1;
    private static final int FIELDS = 2;
    private static final Year EPOCH;

    @Override
    public Year getBuilder() {
        return EPOCH;
    }

    @Override
    public int getFields() {
        return 2;
    }

    @Override
    public Year readField(ProtoStreamReader reader, int index, Year year) throws IOException {
        switch (index) {
            case 0: {
                return Year.of(EPOCH.getValue() + reader.readUInt32());
            }
            case 1: {
                return Year.of(EPOCH.getValue() - reader.readUInt32());
            }
        }
        return year;
    }

    @Override
    public void writeFields(ProtoStreamWriter writer, int startIndex, Year value) throws IOException {
        int year = value.getValue();
        if (year > EPOCH.getValue()) {
            writer.writeUInt32(startIndex + 0, year - EPOCH.getValue());
        } else if (year < EPOCH.getValue()) {
            writer.writeUInt32(startIndex + 1, EPOCH.getValue() - year);
        }
    }

    static {
        EPOCH = Year.of(LocalDate.ofEpochDay(0L).getYear());
    }
}

