/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.impl;

import java.util.Properties;
import org.hibernate.search.engine.impl.MutableEntityIndexBinding;
import org.hibernate.search.indexes.impl.EntityIndexBinder;
import org.hibernate.search.indexes.impl.IndexManagerGroupHolder;
import org.hibernate.search.indexes.impl.NotShardedIndexManagerSelector;
import org.hibernate.search.indexes.interceptor.EntityIndexingInterceptor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.WorkerBuildContext;

class NotShardedEntityIndexBinder
implements EntityIndexBinder {
    private static final String INDEX_BACKEND_NAME_SEPARATOR = "#";
    private final Properties properties;

    public NotShardedEntityIndexBinder(Properties properties) {
        this.properties = properties;
    }

    @Override
    public MutableEntityIndexBinding bind(IndexManagerGroupHolder holder, IndexedTypeIdentifier entityType, EntityIndexingInterceptor<?> interceptor, WorkerBuildContext buildContext) {
        IndexManager indexManager = holder.getOrCreateIndexManager(null, this.properties, entityType, buildContext);
        NotShardedIndexManagerSelector selector = new NotShardedIndexManagerSelector(indexManager);
        return new MutableEntityIndexBinding(holder, selector, null, interceptor);
    }

    @Override
    public String createBackendIdentifier(String backendName, String indexName) {
        return indexName + INDEX_BACKEND_NAME_SEPARATOR + backendName;
    }
}

